/*
   VGA Library
   Set of BIOS of VGA card calls
   Ensemble de fonctions qui font appel au BIOS et la carte VGA
*/

/*
   BIOSscreen
   Get and set the screen mode
    Input:   new mode
    Output:  previous mode

   Lit et change le mode ecran
    Entree:   nouveau mode
    Sortie:   precedent mode

   Modes:   18  VGA Hires
            19  MCGA
             3  Text color
*/

char BIOSscreen(char mode);

/*
   BIOSborder
   Set the screen border color
   Change la couleur du bord de l'cran
*/

void BIOSborder(char color);

/*
   WRITEMODE
   Set a logical write mode for sprite or drawing
   Dfinit un mode logique de sprite ou trace
   Modes:
     0    COPY
    24    XOR
*/

void writemode(int mode);

/*
   WAITREFRESH
   Wait for a screen refresh
   Attente du rafraichissement de l'cran
*/

void waitrefresh();

/*
   SetRGB
   Set the 3 red, green, blue components for a color value
   Definit les 3 composantes rouge, vert, bleu d'une valeur de couleur
*/

void setRGB(char creg, char r, char g, char b);

/*
   BIOScolor
   Set value to a color number
   Affecte une valeur a un numero de couleur
*/

void BIOScolor(int col,int reg);

/*
   Getcolor
   Get value of a color number
   Retourne la valeur d'un numero de couleur
*/

unsigned char getcolor(unsigned char color);
