Comment *
Ŀ
jzchrstr								     
Concatenate a character onto the end of a string adding the null character  
									     
Parms									     
  wstr = string to concatenate to					     
  wch	= char to concatenate						     
									     
Synopsis:								     
									     
   strcpy(wstr,"hello ther");                                               
   wch = 'e'                                                                
   jzchrstr(wstr,wch); 						     

*

;=============================================================================
;				    Data
;=============================================================================

DGROUP	group	_DATA
_DATA	segment word public 'DATA'
	assume	ds:DGROUP

	; Your Data goes here . . .

_DATA	ends

;=============================================================================
;				   Code
;=============================================================================

	assume cs:_text
_text	segment public byte 'code'
	PUBLIC _jzchrstr

_jzchrstr	   proc near

	push bp 			; save base of stack
	mov bp,sp			; establish stack frame

	push di 			; save MS-C's Register vars

	mov di,[bp].4			; get address of dest string
	mov bx,[bp].6			; get character value to concatenate
	xor bh,bh			; set high byte
	xor ax,ax			; search for a zero byte
	mov cx,0FFFFh			; allow 64k max str length
	repnz scasb
	dec di
	mov byte ptr [di],bl		; get char into string
	inc di
	mov byte ptr [di],bh		; get zero into last byte

	pop di				; Restore MS-C's Register vars

	mov sp,bp			; restore stack pointer
	pop  bp 			; and base of stack
	ret				; return to caller

_jzchrstr	   endp
_text	ends
end
