#include <jaz.h>

/*
Ŀ
jzpush.c								     
Push Data onto the stack						     
Synopsis								     
  TSTKHEAD whead;							     
  jzintstk(&whead);   ( initialize the stack header record )		     
  jzpush(&whead,wstr,sizeof(TDATA));					     
									     

*/

jzpush(fhead,fdata,fsize)
TSTKHEAD *fhead;		/* head of stack structure */
char *fdata;			/* pointer to data to save */
unsigned int fsize;		/* number of bytes to put on stack */
{
  TSTACK *wtemp;

  wtemp = (TSTACK *)  malloc(sizeof(TSTACK));	/* get pointer to struct */
  wtemp->pointer = (char *) malloc(fsize);	/* get pointer to data */

  /* copy the data onto the stack */
  memcpy(wtemp->pointer,fdata,fsize);
  wtemp->wint = fsize;		/* save size of data */

  if (fhead->last == 0) {	/* empty stack */
    wtemp->prev  = 0;
    fhead->last  =  wtemp;	/* set last item (top of stack) */
    fhead->first =  wtemp;	/* set first item */
    fhead->numitems = 1;	/* set number of items */
  }
  else {
    wtemp->prev = fhead->last;	/* set link to stack top */
    fhead->last = wtemp;	/* set new top of stack */
    fhead->numitems++;		/* increment stack pointer */
  }
}


