/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

#include <stdio.h>
#include <time.h>
#include <stdlib.h>
#include <jlib.h>

#define NUM_SPRITES 50
#define NUM_ITERATIONS 500
#define RANDOM(u) ( rand() % ( ((u) + 1)  ) )

/* another simple sprite demo,  fixed point this time */

int main(void)
{
 int i;
 unsigned char *pal;
 sprite_system *demo_sprites;
 buffer_rec *offscreen;
 int animation[4] = {0,1,2,1};

 JLIB_DEBUG_OFF
 screen_set_video_mode();

 /* init stuff*/
 offscreen = buff_init(SCREEN_WIDTH,SCREEN_HEIGHT);
 demo_sprites = sprite_init(NUM_SPRITES,64);
 pal = pal_load("demo6.pal");
 
 if((demo_sprites == NULL) || (pal == NULL)){
   jlib_exit("Initialisation Failed.");
 }

 if(sprite_load("demo6.spr",demo_sprites)!=SUCCESS){
    jlib_exit("Sprite Load Failed.");
 }

 srand(time(NULL));

 screen_block_set_pal(pal);

 /* set up sprite movements in fixed point steps */
 for(i=0;i<NUM_SPRITES;i++){
     sprite_set_xy(demo_sprites,i,RANDOM(SCREEN_WIDTH),RANDOM(SCREEN_HEIGHT));
     sprite_set_mode(demo_sprites,i,SPR_MODE_FIXED);
     sprite_set_an_frame(demo_sprites,i,RANDOM(4));
     sprite_set_move_info(demo_sprites,i,RANDOM(32)+1,-1,-1);
     sprite_set_anim_info(demo_sprites,i,RANDOM(16)+1,4,animation);
     sprite_turn_on(demo_sprites,i);
 }
   
 for(i=0;i<NUM_ITERATIONS;i++){
   buff_save_all_sprites(demo_sprites,offscreen);

   buff_draw_all_sprites(demo_sprites,offscreen);

   screen_blit_fs_buffer(offscreen);

   buff_rest_all_sprites(demo_sprites,offscreen);

   sprite_update_all_anim_and_move(demo_sprites);
 };


 screen_restore_video_mode();
 return(1);
}
