/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */
#include <jlib.h>

/* How many bits a character uses */
#define USED_SPACE (CHAR_WIDTH('a')*CHAR_HEIGHT('a'))

int getbit(UBYTE *set, int number)
{
  if(number){
     set += (number / 8);
     return (*set & (1 << (number % 8))) != 0;
  }
  return ((*set) & 1) != 0;
}

/*+------------------------------------------------------------------------+*/
/*|Draw a character in a buffer at x,y in color c without clipping         |*/
/*+------------------------------------------------------------------------+*/
JINLINE void buff_draw_charNC (buffer_rec * buff, UBYTE letter, int x, int y, UBYTE colour)
{
   UBYTE *buffer = B_OFFSET(buff,y) + x;
   int width, height, i;

   JLIB_ENTER("buff_draw_charNC()");

   if (!HAS_FONT (letter)) {
      JLIB_SPRINTF("%d Non Printable.",letter);
      JLIB_LEAVE;
      return;
   }

   i = ((letter - 32) * USED_SPACE);	/* set i to point to letter data */

   for(height = CHAR_HEIGHT(letter);height != 0; height--) {
      for(width = CHAR_WIDTH(letter); width != 0; width--) {
         if(getbit(__font_data,i)) {
            *buffer = colour;
	 }
         i++;
         buffer++;
      }
      buffer += B_X_SIZE(buff) - CHAR_WIDTH(letter);
   }

   JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+*/
/*|Draw a character in a buffer at x,y in color c with clipping            |*/
/*+------------------------------------------------------------------------+*/
JINLINE void buff_draw_char(buffer_rec * buff, UBYTE letter, int x, int y, UBYTE colour)
{
   UBYTE width, height, a, b;
   int i;

   JLIB_ENTER("buff_draw_char");

#ifndef JLIB_PRODUCTION
   jlib_check_buffer(buff);
#endif

   if (!HAS_FONT (letter)) {
      JLIB_SPRINTF("%d non printable.",letter);
      JLIB_LEAVE;
      return;
   }

   width = CHAR_WIDTH (letter);
   height = CHAR_HEIGHT (letter);

   /* trivially reject any letter that is totally off the buffer */
   if((x > B_MAX_X(buff))||(y>B_MAX_Y(buff))||(x+width<0)||((y+height<0))){
      JLIB_LEAVE;
      return;
   }

   /* use non clipping function if we can */
   if((x < B_X_SIZE(buff)-width) && (y < B_Y_SIZE(buff)-height) && (x >= 0) && (y >= 0)){
      buff_draw_charNC(buff,letter,x,y,colour);
      JLIB_LEAVE;
      return;
   }

   i = ((letter - 32) * USED_SPACE); /* set i to point to letter data */

   /* use clipping point function to draw char */
   for(a = 0; a < height; a++) {
      for (b = 0; b < width; b++) {
         if (getbit(__font_data,i)) {
            buff_draw_point(buff, x+b,y+a,colour);
	 }
         i++;
      }
   }

   JLIB_LEAVE;
}


/*+-------------------------------------------------------------------------+*/
/*|Draw a string in buff at x,y in color c without clipping                 |*/
/*+-------------------------------------------------------------------------+*/
void buff_draw_stringNC (buffer_rec * buff, char *string, int x, int y, UBYTE colour)
{
   JLIB_ENTER("buff_draw_stringNC");

   while(*string != '\0'){
      if(HAS_FONT(*string)){
         buff_draw_charNC(buff,*string,x,y,colour);
         x += CHAR_WIDTH(*string);
      }
      string++;
   }

   JLIB_LEAVE;
}


/*+------------------------------------------------------------------------+*/
/*|Draw a string in buff at x,y in color c with clipping.                  |*/
/*+------------------------------------------------------------------------+*/
void buff_draw_string(buffer_rec * buff, char *string, int x, int y, UBYTE colour)
{
   int width,height;

   JLIB_ENTER("buff_draw_string");

#ifndef JLIB_PRODUCTION
   if(string == NULL){
      jlib_exit(jlib_msg(JLIB_ENULL));
   }
   jlib_check_buffer(buff);
#endif

   width  = B_MAX_X(buff);
   height = B_MAX_Y(buff);

   /* trivially reject any string that begins off the buffer */
   if((x > width) || (y > height) || (y+CHAR_HEIGHT('a') > height)){
      JLIB_LEAVE;
      return;
   }

   while(*string != '\0'){
      if(HAS_FONT(*string)){
         buff_draw_char(buff,*string,x,y,colour);
         x += CHAR_WIDTH(*string);
      }
      string++;
   }

   JLIB_LEAVE;
}
