/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

#include <dos.h>
#include <jlib.h>
#include <go32.h>

char version_string[] = "djgpp V2 mode 13h";
unsigned int _jlib_off;          /* dos memory offset */
unsigned short _jlib_sel;        /* dos memory selector */

static UBYTE __jlib_previous_mode = 0x3;       /* previous text mode */
static UBYTE __jlib_screen_initted=0;


/*+------------------------------------------------------------------------+ */ 
/*|Set the video mode.                                                     | */ 
/*+------------------------------------------------------------------------+ */ 
int screen_set_video_mode(void) 
{
  if(!__jlib_screen_initted){
   
      union REGS r;

      JLIB_SIGNAL_SETUP;

      /* save text mode */
      r.h.ah = 0x0f;
      
      int86 (0x10,&r,&r);
      
      __jlib_previous_mode= r.h.al;
      
      r.x.ax = 0x13;
      int86 (0x10, &r, &r);     /* set mode 13h */
   
      _jlib_sel = _dos_ds;
      _jlib_off = 0;
  
      __jlib_screen_initted=1;
      return 1;                 /* successful setup */
  }

  return 0;
}


/*+------------------------------------------------------------------------+ */ 
/*|Restore the video mode.                                                 | */
/*+------------------------------------------------------------------------+ */ 
void screen_restore_video_mode(void) 
{
  union REGS r;

  if(__jlib_screen_initted){
      r.x.ax = (unsigned short)__jlib_previous_mode;
      int86(0x10, &r, &r);
      __jlib_screen_initted=0;
  } 
}


/*+------------------------------------------------------------------------+ */ 
/*|Return the current page number.                                         | */
/*+------------------------------------------------------------------------+ */ 
int screen_get_page (void) 
{
      return 1;
}


/*+------------------------------------------------------------------------+ */ 
/*|Show the current drawing page.                                          | */ 
/*+------------------------------------------------------------------------+ */ 
void screen_show_page (int page) 
{
   /* do nothing */ 
}


/*+------------------------------------------------------------------------+ */ 
/*|Set drawing output to a page.                                           | */ 
/*+------------------------------------------------------------------------+ */ 
void screen_set_page(int page)
{
 /* do nothing */
}


/*+------------------------------------------------------------------------+ */ 
/*|Fill the screen with a given color.                                     | */ 
/*+------------------------------------------------------------------------+ */ 
#define do_screen_fill(col)            \
  asm volatile(                         "\n\
     pushw %%es \n \
     movw __jlib_sel, %%es \n \
     push %%ecx \n \
     movl $0xA0000, %%edi \n \
     movl $16000, %%ecx \n \
     movb %0,%%al  \n \
     shll $8,%%eax \n \
     movb %0,%%al  \n \
     shll $8,%%eax \n \
     movb %0,%%al \n \
     shll $8,%%eax \n \
     movb %0,%%al \n \
     rep \n \
     stosl \n \
     pop %%ecx \n \
     popw %%es "\
     :                               /* NOTHING */ \
     :" g " (col)       \
     :"di", "ax", "cx")

void screen_fill (UBYTE color) 
{
 do_screen_fill(color); 
}


/*+------------------------------------------------------------------------+ */ 
/*|Clear the screen.                                                       | */ 
/*+------------------------------------------------------------------------+ */ 
void screen_clear (void) 
{
 do_screen_fill(0); 
}

#define MASK_1 0x00000001
#define MASK_16s 0xfffffff0

/* return the best copy method for two addresses and a length */
JINLINE int get_best_copy_method (void *addr1, void *addr2, unsigned int len)
{
   if (len & MASK_16s){
	/* len is > 16 */
	(unsigned int) addr1 += (unsigned int) addr2;

	if ((unsigned int) addr1 & MASK_1){
	     /* one address is odd, one is even */
	     return ALIGNMENT_STATE_1;
	}
	else{
	     /* both address are either odd or even */
	     if ((unsigned int) addr2 & MASK_1){
		  /* both are odd */
		  if (len & MASK_1){
		       return ALIGNMENT_STATE_2;	/* length is odd */
		  }
		  else{
		       return ALIGNMENT_STATE_5;	/* length is even */
		  }
	     }
	     else{
		  /* both are even */
		  if (len & MASK_1){
		       return ALIGNMENT_STATE_4;	/* length is odd */
		  }
		  else{
		       return ALIGNMENT_STATE_3;	/* length is even */
		  }
	     }
	}
   }
   else{
	/* len is <= 16, use sb */
	return ALIGNMENT_STATE_1;
   }
}
