/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

#include <jlib.h>
#include <stdio.h>

/*+------------------------------------------------------------------------+ */
/*|blit a fullscreen buffer to the screen                                  | */
/*+------------------------------------------------------------------------+ */
void screen_blit_fs_buffer (buffer_rec * buff)
{
 FAST_LONG_COPY(buff->buffer,(int*)MODE_13H_START,64000);
}


/*+------------------------------------------------------------------------+ */
/*|blit part of a buffer to the screen without clipping.                   | */
/*+------------------------------------------------------------------------+ */
void screen_blit_buff_toNC (int x, int y, buffer_rec * sbuff,
			 int sbx1, int sby1, int sbx2, int sby2)
{
   unsigned int sbuffx = B_X_SIZE (sbuff);
   UBYTE *src = B_BUFF_PTR (sbuff) + (sbuffx * sby1) + sbx1;
   UBYTE *dest = (UBYTE *) MODE_13H_START + (y * SCREEN_WIDTH) + x;
   unsigned int h_len = sbx2 - sbx1+1;
   unsigned int v_iterations = sby2 - sby1+1;

   for (; v_iterations != 0; v_iterations--){
             FAST_SHORT_COPY(src, dest, h_len);
	     src += sbuffx;
	     dest += SCREEN_WIDTH;
   }
}

/*+------------------------------------------------------------------------+ */
/*|blit part of a buffer to the screen with clipping.                      | */
/*+------------------------------------------------------------------------+ */
void screen_blit_buff_to (int x, int y, buffer_rec * sbuff,
			  int sbx1, int sby1, int sbx2, int sby2)
{
   UBYTE *src;
   UBYTE *dest = (UBYTE *) MODE_13H_START;
   unsigned int h_len,v_iterations;
   unsigned int sbuffx,sbuffy;

   sbuffx = B_MAX_X(sbuff);
   sbuffy = B_MAX_Y(sbuff);
   src = B_BUFF_PTR(sbuff);
   
   /* sort coordinates if needed */
   if (sbx2 < sbx1){
        JLIB_SWAP(sbx1, sbx2);
   }
   if (sby2 < sby1){
        JLIB_SWAP(sby1, sby2);
   }

   /* clip src buffer */
   if((sbx1>sbuffx) ||(sby1>sbuffy) || (sbx2<0) || (sby2<0)){
      return;
   }

   if(sbx1<0){
      sbx1=0;
   }
   if(sby1<0){
      sby1=0;
   }
   if(sbx2>sbuffx){
      sbx2=sbuffx;
   }
   if(sby2>sbuffy){
      sby2=sbuffy;
   }

   /* clip to screen */
   if((x > SCREEN_MAX_X) || (y > SCREEN_MAX_Y)){
	return;
   }
   if(x<0){
      sbx1-=x;
      x=0;
      if(sbx1>sbx2){
         return;
      }
   }
   if(y<0){
      sby1-=y;
      y=0;
      if(sby1>sby2){
         return;
      }
   }

   sbuffx++; /* from max x to buffer width */
   src += (sby1 * sbuffx) + sbx1;
   dest += (y * SCREEN_WIDTH) + x;

   v_iterations = (sby2 - sby1)+1;        /* number of times to repeat horiz. blit */
   h_len = (sbx2 - sbx1)+1;       /* length of horizontal blit */

   /* test coordinates to clip area drawn */
   if (x + h_len > SCREEN_WIDTH){
        h_len = SCREEN_WIDTH - x;
   }
   if (y + v_iterations > SCREEN_HEIGHT){
        v_iterations = SCREEN_HEIGHT - y;
   }


   for(; v_iterations != 0; v_iterations--){
       FAST_SHORT_COPY(src, dest, h_len);
       src += sbuffx;
       dest += SCREEN_WIDTH;
   }
}
