/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */

#include <i86.h>
#include <jlib.h>
#include <stdio.h>

char version_string[] = "WATCOM C mode 13h";
static UBYTE __jlib_previous_mode=0x3;       /* previous text mode */
static UBYTE __jlib_screen_initted=0;

int screen_set_video_mode(void)
{
  union REGS r;

  if(!__jlib_screen_initted){

      /* save text mode */
      r.h.ah = 0x0f;
      
      int386 (0x10,&r,&r);
      
      __jlib_previous_mode = r.h.al;
      
      /* set mode 13h */
      r.x.eax = 0x13;
   
      int386 (0x10, &r, &r);
      __jlib_screen_initted=1;
   
      return 1;                 /* successful setup */
  }
  else{
      return 0;
  }
}

void screen_restore_video_mode(void)
{
  union REGS r;

  if(__jlib_screen_initted){
      /* reset video mode */
      r.x.eax = __jlib_previous_mode;
      int386 (0x10, &r, &r);
      __jlib_screen_initted=0;
  }
}


/*+------------------------------------------------------------------------+ */
/*|Return the current page number.                                         | */
/*+------------------------------------------------------------------------+ */
int screen_get_page (void)
{
   return 1;
}


/*+------------------------------------------------------------------------+ */
/*|set the given  page number.                                             | */
/*+------------------------------------------------------------------------+ */
void screen_set_page (int page)
{
 /* do nothing */
}


/*+------------------------------------------------------------------------+ */
/*|Show the current drawing page.                                          | */
/*+------------------------------------------------------------------------+ */
void screen_show_page (int page)
{
   /* do nothing */
}


/*+------------------------------------------------------------------------+ */ 
/*|Wait for the retrace beam to move offscreen.                            | */ 
/*+------------------------------------------------------------------------+ */ 
void screen_wait_vsync (void)
{
   /* not implememted yet */
}


/*+------------------------------------------------------------------------+ */ 
/*|Fill the screen with a given color.                                     | */ 
/*+------------------------------------------------------------------------+ */ 
void screen_fill (UBYTE color)
{
 MEM_STORE_LONG(MODE_13H_START,color,64000);
}


/*+------------------------------------------------------------------------+ */ 
/*|Clear the screen.                                                       | */ 
/*+------------------------------------------------------------------------+ */ 
void screen_clear (void) 
{
 screen_fill(0); 
}


int get_best_copy_method (void *addr1, void *addr2, unsigned int len)
{
 return ALIGNMENT_STATE_1;
}

