/* Copyright 1995-96 Jon Griffiths.  See the file "jlib.doc" for details. */
/*
 * X Version Copyright (C) 1995 Mike Manley
 *
 * Minor bugfixes/enhancements 1996 by Henrik Schmidt 
 * Based on SVGA code by Jonathan Paul Griffiths
 */

#include <jlib.h>
#include <X11/Xlib.h>

/*+------------------------------------------------------------------------+*/
/*|blit a fullscreen buffer to the screen                                  |*/
/*+------------------------------------------------------------------------+*/
JINLINE void screen_blit_fs_buffer(buffer_rec *buff)
{
	/* This should be able to be optimised so the XCreateGC and XCreateImage */
	/* aren't called everytime - note ideally the XImage should be created */
	/* and managed as part of the buffer_rec */
	
XImage *image;

  /* Create image */
  image = XCreateImage(jxdisplay, DefaultVisual(jxdisplay, jxscreen), 8,
					   ZPixmap, 0, B_BUFF_PTR(buff),
					   SCREEN_WIDTH, SCREEN_HEIGHT, 8, SCREEN_WIDTH);
  /* Put to window */
  XPutImage(jxdisplay, jxwindow, jxgc, image, 0, 0, 0, 0,
			SCREEN_WIDTH, SCREEN_HEIGHT);
  /* Delete the image */
  XFree(image);
}

/*+------------------------------------------------------------------------+*/
/*|blit part of a buffer to the screen without clipping.                   |*/
/*+------------------------------------------------------------------------+*/
JINLINE void screen_blit_buff_toNC(int x,int y,buffer_rec *sbuff,
			  int sbx1, int sby1,int sbx2, int sby2)
{
XImage *image;
int width,height;

 if(sbx1 > sbx2){
   JLIB_SWAP(sbx1,sbx2);
 }
 
 if(sby1 > sby2){
   JLIB_SWAP(sby1,sby2);
 }  

 width = sbx2 - sbx1;
 height = sby2 - sby1;

 if( x > SCREEN_MAX_X || y > SCREEN_MAX_Y ){
   return;
 }  

  image = XCreateImage(jxdisplay, DefaultVisual(jxdisplay, jxscreen), 8,
					   ZPixmap, 0, B_BUFF_PTR(sbuff),
					   B_X_SIZE(sbuff), B_Y_SIZE(sbuff), 8, B_X_SIZE(sbuff));

  XPutImage(jxdisplay, jxwindow, jxgc, image, sbx1, sby1, x, y, width, height);
  XFree(image);
}


/*+------------------------------------------------------------------------+*/
/*|blit part of a buffer to the screen with clipping.                      |*/
/*+------------------------------------------------------------------------+*/
JINLINE void screen_blit_buff_to(int x,int y,buffer_rec *sbuff,
			 int sbx1, int sby1,int sbx2, int sby2)
{
XImage *image;
int width,height;

  if(sbx1 > sbx2){
	JLIB_SWAP(sbx1,sbx2);
  }
  
  if(sby1 > sby2){
	JLIB_SWAP(sby1,sby2);
  }  
  
  width = sbx2 - sbx1;
  height = sby2 - sby1;
  
  if( x > SCREEN_MAX_X || y > SCREEN_MAX_Y ){
	return;
  }  
  
  if( x + width > SCREEN_MAX_X){
	width = SCREEN_MAX_X - x;
  }  
  
  if( y + height > SCREEN_MAX_Y){
	height = SCREEN_MAX_Y - y;
  }  
  
  image = XCreateImage(jxdisplay, DefaultVisual(jxdisplay, jxscreen), 8,
					   ZPixmap, 0, B_BUFF_PTR(sbuff),
					   B_X_SIZE(sbuff), B_Y_SIZE(sbuff), 8, B_X_SIZE(sbuff));
   
  XPutImage(jxdisplay, jxwindow, jxgc, image, sbx1, sby1, x, y, width, height);
  XFree(image);
}

