/* spr_join.c - join several sprite files
**
** First version by Jonathan Paul Griffiths.
** Copyright (C) 1995 All rights reserved.
**
** New version by Arturo Espinosa <arturo@nuclecu.unam.mx>
** 
** See "jlib.doc" for copyright details.
*/

/* Files are written in order 1,2 ..n to the outout file */

#include <stdio.h>
#include <jlib.h>

void open_file(FILE **input, char *filename,char *mode);


int main(int argc, char *argv[])
{
  FILE *input,*output;
  int i, j, k;
  USHORT n1,total;
  unsigned char w,h;

  if(argc < 4){
     puts("joinspr - join sprite files together.");
     puts("Usage: joinspr <infile1> ... <infile n> <outfile>");
     puts("Where: <infile 1> = 1st file to get sprites from (include extn)");
     puts("       <infile n> = last file to get sprites from (include extn)");   
     puts("       <outfile>  = file to put output into (include extn)");
     exit(-1);
  }

  open_file (&output, argv[argc - 1], "wb");
	
  /* get number of sprites in each file */
  total = 0;
  for(i = 1; i < argc - 1; i++){
     open_file(&input, argv[i], "rb");
     jio_read_elementary_type(input,&n1,sizeof(USHORT));
     total += n1;
     fclose(input);
  }

  jio_write_elementary_type(output,&total,sizeof(USHORT));

  /* copy out sprite files */
  for(k = 1; k < argc - 1; k++){
     open_file(&input, argv[k], "rb");
     jio_read_elementary_type(input,&n1,sizeof(USHORT));
     for(i = 0; i < n1; i++){
        w=fgetc(input);
        h=fgetc(input);
        fputc(w, output);
        fputc(h, output);
      
     for(j = 0; j < w * h; j++)
        fputc(fgetc(input), output);

        w = fgetc(input); /* no of bounding rects */
        fputc(w, output);

	for(j = 0; j < w; j++){
           fputc(fgetc(input),output);   /* write each rectangle output */
           fputc(fgetc(input),output);
           fputc(fgetc(input),output);
           fputc(fgetc(input),output);
        }

     }
     fclose(input);
  }
	
  fclose(output);
	
  return (0);      
}

void open_file(FILE **input, char *filename,char *mode)
{  
 if(((*input) = fopen(filename,mode))==NULL){
    printf("ERROR: Could not open file %s for %s.",filename,mode);
    exit(-1);
 }
}

