/**  locale.c ************************************************************

     Locales' support for DOS / Win31 / Win32.
            Copyright (c) 1995-1997  by Timofei Bondarenko <tim@ipi.ac.ru>

     POSIX-friendly control of locales.
 *-----------------------------------------------------------------------*/
#include "config.h"
#include <string.h>

#include "_locale.h"

#ifdef LC_MESSAGES
#define LCount 6
#else
#define LCount 5
#endif

const char _lcs_DEF_[] = _DEFlocale_D_,
           _lcs_C_  [] = _DEFlocale_C_;

#if !LINK_NUMMON || defined(LC_MESSAGES)
static LC_ID_ _lc_empty_(LC_ID_ ccp) { return _lcn_C_/*ccp*/; }
#endif

LC_ID_ (*_lc_fptr_[])(LC_ID_) =
      { _lc_ctype_, _lc_collate_, _lc_time_
#if    LINK_NUMMON
      , _lc_numeric_, _lc_monetary_
#else
      , _lc_empty_,   _lc_empty_
#endif
#ifdef LC_MESSAGES
      , _lc_empty_
#endif
      };

char *setlocale(int category, const char *locale)
{
 static int  lc_cat[LCount] =
       { LC_CTYPE, LC_COLLATE, LC_TIME, LC_NUMERIC, LC_MONETARY
#ifdef LC_MESSAGES
       , LC_MESSAGES
#endif
       };
 static char lc_val[LCS_0 * LCount] = _DEFlocale_C_"~"
                                      _DEFlocale_C_"~"
                                      _DEFlocale_C_"~"
                                      _DEFlocale_C_"~"
#ifdef LC_MESSAGES
                                      _DEFlocale_C_"~"
#endif
                                      _DEFlocale_C_;
 int cat;

 if (locale)
   {
    int step;
    cat = step = 0;

    switch(strlen(locale))
      {
    case LCS_0*LCount-1:     /* LC_ALL: "C C C ..." */
                if (category != LC_ALL) return NULL;
                step = LCS_0;
       break;
    case 0:     locale = _lcs_DEF_;      /* "" */
       break;
#if 1
    default: /* let _lc_str2lid() to detect an invalid value */
       break;
#else
    case 1:                              /* "C" */
#if 1 != LCS_
    case LCS_:  /* a valid locale's name like "12345678" */
#endif
       break;
    default:    return NULL;
#endif
      }

    do {
        LC_ID_ ccp;
        if (LC_ALL == category || lc_cat[cat] == category)
          if (_lcn_BAD_ == (ccp = _lc_str2lid_(locale)) ||
              _lcn_BAD_ == (ccp = _lc_fptr_[cat](ccp))) return NULL;
          else _lc_lid2str_(lc_val + LCS_0*cat, ccp);
        locale += step;
       }
    while(LCount > ++cat);
   }

 locale = lc_val;
 for(cat = 0; cat < LCount; cat++)
   if (category == lc_cat[cat])
     {
      ((char*)locale)[LCS_] = '\0';
      goto Return;
     }
   else
     {
      ((char*)locale)[LCS_] = lcBRK_;
      locale += LCS_0;
     }
 locale = lc_val;
 lc_val[LCS_0*LCount-1] = '\0';
 if (category != LC_ALL) return NULL;
Return:
#if LCS_ > 1
 return (char*)(strcmp(locale, _lcs_C_)? locale: "C");
#else
 return (char*)locale;
#endif
}

/* end of locale.c */