/**  stricmp.c ***********************************************************

     Locales' support for DOS / Win31 / Win32.
            Copyright (c) 1995-1997  by Timofei Bondarenko <tim@ipi.ac.ru>

     Locale dependent routines:     stricmp(), strnicmp().
 *-----------------------------------------------------------------------*/
#include "config.h"
#include <string.h>
#ifdef __DJGPP__
#include <ctype.h>
#endif
#include "_locale.h"

/*************** Non standard, but useful routines ***************/

int strnicmp(const char *s1, const char *s2, size_t n)
{
 int ci = 0;
 while(n-- && !(ci = (int)_lc_igncase[*(unsigned char*)s1++] -
                     (int)_lc_igncase[*(unsigned char*)s2]) && *s2++);
 return ci;
}

int stricmp(const char *s1, const char *s2)
{
#if 1
 int ci;
 while(!(ci = (int)_lc_igncase[*(unsigned char*)s1++] -
              (int)_lc_igncase[*(unsigned char*)s2]) && *s2++);
 return ci;
#else
 return strnicmp(s1, s2, ~0);
#endif
}

/* end of stricmp.c */