/* xxconic.h                    freeware                   xhunga@tiscali.fr  */


/* ------------------------------ FUNCTION ----------------------  mofconic() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void mofconicA(

pmatrix mpxy,
pmatrix mOut)
{
   int i;
   int j;
   int p;


    i = 0 ;
    j = 0 ;
  *(mOut->pblock + i *mOut->cols + j    )        = 1;
  *(mOut->pblock + i *mOut->cols + j + 1)        = 1;

  for (   j = 2 ; j < mOut->cols -2    ; j++, j++)
  {
   *(mOut->pblock + i *mOut->cols + j    )        = 0;
   *(mOut->pblock + i *mOut->cols + j + 1)        = 1;
  }

  *(mOut->pblock + i *mOut->cols + j    )        =  1;
  *(mOut->pblock + i *mOut->cols + j + 1)        =  1;

  for (   i = 1 ; i < mOut->rows    ; i++)
   {      j = 0 ;

                                                                      /* x**2 */
          *(mOut->pblock + i *mOut->cols + j    )        = \
      pow(*(mpxy->pblock + (i-1)  *mpxy->cols        ),2);
          *(mOut->pblock + i *mOut->cols + j + 1)        = \
      pow(*(mpxy->pblock + (i-1)  *mpxy->cols     + 1),2);

            j++; j++;                                                 /* y**2 */
          *(mOut->pblock + i *mOut->cols + j    )        = \
      pow(*(mpxy->pblock + (i-1)  *mpxy->cols  + 2      ),2);
          *(mOut->pblock + i *mOut->cols + j + 1)        = \
      pow(*(mpxy->pblock + (i-1)  *mpxy->cols + 2   + 1),2);

            j++; j++;                                                 /* x    */
          *(mOut->pblock + i *mOut->cols + j    )        = \
          *(mpxy->pblock + (i-1)  *mpxy->cols        );
          *(mOut->pblock + i *mOut->cols + j + 1)        = \
          *(mpxy->pblock + (i-1)  *mpxy->cols     + 1);

            j++; j++;                                                 /* y    */
          *(mOut->pblock + i *mOut->cols + j    )        = \
          *(mpxy->pblock + (i-1)  *mpxy->cols  + 2      );
          *(mOut->pblock + i *mOut->cols + j + 1)        = \
          *(mpxy->pblock + (i-1)  *mpxy->cols + 2   + 1);

            j++; j++;
          *(mOut->pblock + i *mOut->cols + j    )        =  1;
          *(mOut->pblock + i *mOut->cols + j + 1)        =  1;

            j++; j++;
          *(mOut->pblock + i *mOut->cols + j    )        =  0;
          *(mOut->pblock + i *mOut->cols + j + 1)        =  1;
    }
}


/* ------------------------------ FUNCTION ----------------------  mofconic() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void mofconicE(

pmatrix mpxy,
pmatrix mOut)
{
   int i;
   int j;
   int p;

  for (   i = 0 ; i < mOut->rows -1  ; i++)
   {      j = 0 ;
                                                                      /* x**2 */
          *(mOut->pblock + i *mOut->cols + j    )        = \
      pow(*(mpxy->pblock + (i)  *mpxy->cols        ),2);
          *(mOut->pblock + i *mOut->cols + j + 1)        = \
      pow(*(mpxy->pblock + (i)  *mpxy->cols     + 1),2);

            j++; j++;                                                 /* y**2 */
          *(mOut->pblock + i *mOut->cols + j    )        = \
      pow(*(mpxy->pblock + (i)  *mpxy->cols  + 2      ),2);
          *(mOut->pblock + i *mOut->cols + j + 1)        = \
      pow(*(mpxy->pblock + (i)  *mpxy->cols + 2   + 1),2);
                             
            j++; j++;                                                 /* x    */
          *(mOut->pblock + i *mOut->cols + j    )        = \
          *(mpxy->pblock + (i)  *mpxy->cols        );
          *(mOut->pblock + i *mOut->cols + j + 1)        = \
          *(mpxy->pblock + (i)  *mpxy->cols     + 1);

            j++; j++;                                                 /* y    */
          *(mOut->pblock + i *mOut->cols + j    )        = \
          *(mpxy->pblock + (i)  *mpxy->cols  + 2      );
          *(mOut->pblock + i *mOut->cols + j + 1)        = \
          *(mpxy->pblock + (i)  *mpxy->cols + 2   + 1);

            j++; j++;
          *(mOut->pblock + i *mOut->cols + j    )        =  1;
          *(mOut->pblock + i *mOut->cols + j + 1)        =  1;

            j++; j++;
          *(mOut->pblock + i *mOut->cols + j    )        =  0;
          *(mOut->pblock + i *mOut->cols + j + 1)        =  1;
    }


    i = mOut->rows -1;

  for (   j = 0 ; j < mOut->cols - 4    ; j++, j++)
  {
   *(mOut->pblock + i *mOut->cols + j    )        = 0;
   *(mOut->pblock + i *mOut->cols + j + 1)        = 1;
  }

  *(mOut->pblock + i *mOut->cols + j    )        =  1;
  *(mOut->pblock + i *mOut->cols + j + 1)        =  1;

    j++, j++;
  *(mOut->pblock + i *mOut->cols + j    )        =  1;
  *(mOut->pblock + i *mOut->cols + j + 1)        =  1;

}


/* ------------------------------ FUNCTION ----------------------  mofconic() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void mofcircle(

pmatrix mpxy,
pmatrix mOut)
{
   int i;
   int j;
   int p;

    i = 0 ;
    j = 0 ;
  *(mOut->pblock + i *mOut->cols + j    )        = 1;
  *(mOut->pblock + i *mOut->cols + j + 1)        = 1;

  for (   j = 2 ; j < mOut->cols -2    ; j++, j++)
  {
   *(mOut->pblock + i *mOut->cols + j    )        = 0;
   *(mOut->pblock + i *mOut->cols + j + 1)        = 1;
  }

  *(mOut->pblock + i *mOut->cols + j    )        =  1;
  *(mOut->pblock + i *mOut->cols + j + 1)        =  1;

    i = 1 ;
    j = 0 ;
  *(mOut->pblock + i *mOut->cols + j    )        = 0;                 /*a y**2*/
  *(mOut->pblock + i *mOut->cols + j + 1)        = 1;

    j++, j++;
  *(mOut->pblock + i *mOut->cols + j    )        = 1;
  *(mOut->pblock + i *mOut->cols + j + 1)        = 1;

  for (   j = 4 ; j < mOut->cols -2    ; j++, j++)
  {
   *(mOut->pblock + i *mOut->cols + j    )        = 0;
   *(mOut->pblock + i *mOut->cols + j + 1)        = 1;
  }

  *(mOut->pblock + i *mOut->cols + j    )        =  1;
  *(mOut->pblock + i *mOut->cols + j + 1)        =  1;

  for (   i = 2 ; i < mOut->rows    ; i++)
   {      j = 0 ;

          *(mOut->pblock + i *mOut->cols + j    )        = \
      pow(*(mpxy->pblock + (i-2)  *mpxy->cols        ),2);
          *(mOut->pblock + i *mOut->cols + j + 1)        = \
      pow(*(mpxy->pblock + (i-2)  *mpxy->cols     + 1),2);

            j++; j++;                                                 /* y**2 */
          *(mOut->pblock + i *mOut->cols + j    )        = \
      pow(*(mpxy->pblock + (i-2)  *mpxy->cols  + 2      ),2);
          *(mOut->pblock + i *mOut->cols + j + 1)        = \
      pow(*(mpxy->pblock + (i-2)  *mpxy->cols + 2   + 1),2);

            j++; j++;                                                 /* x    */
          *(mOut->pblock + i *mOut->cols + j    )        = \
          *(mpxy->pblock + (i-2)  *mpxy->cols        );
          *(mOut->pblock + i *mOut->cols + j + 1)        = \
          *(mpxy->pblock + (i-2)  *mpxy->cols     + 1);

            j++; j++;                                                 /* y    */
          *(mOut->pblock + i *mOut->cols + j    )        = \
          *(mpxy->pblock + (i-2)  *mpxy->cols  + 2      );
          *(mOut->pblock + i *mOut->cols + j + 1)        = \
          *(mpxy->pblock + (i-2)  *mpxy->cols + 2   + 1);

            j++; j++;
          *(mOut->pblock + i *mOut->cols + j    )        =  1;
          *(mOut->pblock + i *mOut->cols + j + 1)        =  1;

            j++; j++;
          *(mOut->pblock + i *mOut->cols + j    )        =  0;
          *(mOut->pblock + i *mOut->cols + j + 1)        =  1;
    }
}



/* ------------------------------ FUNCTION ------------------ conicresultis() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void conicresultis(
pmatrix mOut)
{
int i;
int p = mOut->rows;

    i = 0;
    if((*(mOut->pblock + i *mOut->cols + mOut->cols-2)))
    printf("   %+.0f/%.0f x**2 ",
            *(mOut->pblock + i *mOut->cols + mOut->cols-2),
            *(mOut->pblock + i *mOut->cols + mOut->cols-1));
    i++;
    if((*(mOut->pblock + i *mOut->cols + mOut->cols-2)))
    {
    printf("%+.0f/%.0f y**2 ",
            *(mOut->pblock + i *mOut->cols + mOut->cols-2),
            *(mOut->pblock + i *mOut->cols + mOut->cols-1));
    }

    i++;
    if((*(mOut->pblock + i *mOut->cols + mOut->cols-2)))
    {
    printf("%+.0f/%.0f x ",
            *(mOut->pblock + i *mOut->cols + mOut->cols-2),
            *(mOut->pblock + i *mOut->cols + mOut->cols-1));
    }

    i++;
    if((*(mOut->pblock + i *mOut->cols + mOut->cols-2)))
    {
    printf("%+.0f/%.0f y ",
            *(mOut->pblock + i *mOut->cols + mOut->cols-2),
            *(mOut->pblock + i *mOut->cols + mOut->cols-1));
    }

    i++;
    if((*(mOut->pblock + i *mOut->cols + mOut->cols-2)))
    {
    printf("%+.0f/%.0f ",
            *(mOut->pblock + i *mOut->cols + mOut->cols-2),
            *(mOut->pblock + i *mOut->cols + mOut->cols-1));
    }

    printf(" = 0 ");

   printf("\n");
}

/* ------------------------------ FUNCTION ---------------- calculate_conic() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void calculate_conic(
pmatrix mOut,
fraction fx,
fraction fy)
{
int i;
fraction fT;
fraction fT2;

fT2.numer = 0;
fT2.denom = 1;

    i = 0;

    fT.numer = *(mOut->pblock + i *mOut->cols + mOut->cols-2) * \
                     pow(fx.numer,2);
    fT.denom = *(mOut->pblock + i *mOut->cols + mOut->cols-1) * \
                     pow(fx.denom,2);

    fT2 = addF(fT2,fT);

    i++;

    fT.numer = *(mOut->pblock + i *mOut->cols + mOut->cols-2) * \
                     pow(fy.numer,2);
    fT.denom = *(mOut->pblock + i *mOut->cols + mOut->cols-1) * \
                     pow(fy.denom,2);

    fT2 = addF(fT2,fT);

    i++;
    fT.numer = *(mOut->pblock + i *mOut->cols + mOut->cols-2) * fx.numer;
    fT.denom = *(mOut->pblock + i *mOut->cols + mOut->cols-1) * fx.denom;

    fT2 = addF(fT2,fT);

    i++;
    fT.numer = *(mOut->pblock + i *mOut->cols + mOut->cols-2) * fy.numer;
    fT.denom = *(mOut->pblock + i *mOut->cols + mOut->cols-1) * fy.denom;

    fT2 = addF(fT2,fT);

    i++;
    fT.numer = *(mOut->pblock + i *mOut->cols + mOut->cols-2);
    fT.denom = *(mOut->pblock + i *mOut->cols + mOut->cols-1);

    fT2 = addF(fT2,fT);

   printf(" With x = %2.0f/%.0f and  y = %2.0f/%.0f ",
           fx.numer,fx.denom,
           fy.numer,fy.denom);

   printf("  a x**2 + b y**2 + c x + d y + e = %3.0f/%.0f \n",
           fT2.numer,fT2.denom);

}


/* ------------------------------ FUNCTION ---------------- calculate_circle() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void calculate_circle(
pmatrix mOut,
fraction fx,
fraction fy)
{
int i;
fraction fT;
fraction fT2;

fT2.numer = 0;
fT2.denom = 1;

    i = 0;

    fT.numer = *(mOut->pblock + i *mOut->cols + mOut->cols-2) * \
                     pow(fx.numer,2);
    fT.denom = *(mOut->pblock + i *mOut->cols + mOut->cols-1) * \
                     pow(fx.denom,2);

    fT2 = addF(fT2,fT);

    i++;

    fT.numer = *(mOut->pblock + i *mOut->cols + mOut->cols-2) * \
                     pow(fy.numer,2);
    fT.denom = *(mOut->pblock + i *mOut->cols + mOut->cols-1) * \
                     pow(fy.denom,2);

    fT2 = addF(fT2,fT);

    i++;
    fT.numer = *(mOut->pblock + i *mOut->cols + mOut->cols-2) * fx.numer;
    fT.denom = *(mOut->pblock + i *mOut->cols + mOut->cols-1) * fx.denom;

    fT2 = addF(fT2,fT);

    i++;
    fT.numer = *(mOut->pblock + i *mOut->cols + mOut->cols-2) * fy.numer;
    fT.denom = *(mOut->pblock + i *mOut->cols + mOut->cols-1) * fy.denom;

    fT2 = addF(fT2,fT);

    i++;
    fT.numer = *(mOut->pblock + i *mOut->cols + mOut->cols-2);
    fT.denom = *(mOut->pblock + i *mOut->cols + mOut->cols-1);

    fT2 = addF(fT2,fT);

   printf(" With x = %2.0f/%.0f and  y = %2.0f/%.0f ",
           fx.numer,fx.denom,
           fy.numer,fy.denom);

   printf("  a x**2 + a y**2 + b x + c y + d = %3.0f/%.0f \n",
           fT2.numer,fT2.denom);

}


