/*
 *    File table.cpp
 *      Demonstrates the use of the STATUSBAR Object
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "mguipp.h"

#include "mguitest.hpp"

class TableFormDialog : public CmCallback
{
    CmShell *shell;
    CmAbsTableForm *table;
public:
    TableFormDialog();
    void closeDialog(void) { delete shell; delete this; };
    void clearTable(void);
    void addRows(void);
};

void TableFormDialog::clearTable(void)
{
    table->deleteDataRows();
}

void TableFormDialog::addRows(void)
{
    int ii;
    int nc = 6;
    char buff[32];
    CmLabel *lbl;

    table->unmap();
    for (ii=0; ii < 5*nc; ii++)
    {
	sprintf(buff, "Cell %d - %d", ii/nc, ii%nc);
	lbl = new CmLabel(table, buff,  FIXED_MEDIUM);
	lbl->setShadow(WS_SHADOW_IN, 1, 0);
	lbl->setAlignment((ii%nc) ? LEFT_ALIGN : RIGHT_ALIGN);
    }
    table->map();
}

TableFormDialog::TableFormDialog(void)
{
    CmSFile *sfile;
    CmPushButton *pb;
    CmLabel *lbl;
    int ii, nc;
    char buff[64];

    shell = new CmShell("Table Form", 0);
/*
 * Let's create a TableForm with 'nc' columns
 */
    nc = 6;
    table = new CmScrolledTableForm(shell, nc, 200, 180, 1, 1);

    table->setSpacing(3);
    table->setShadow(WS_NONE, 0, 0);

    for (ii=0; ii < nc; ii++)
    {
	sprintf(buff, "Head %d - %d", ii/nc, ii%nc);
	new CmPushButton(table, buff, TIMES_MEDIUM);
    }
 /*
  * Now let's add 5 rows of Label objects
  */
    for (ii=0; ii < 4*nc; ii++)
    {
	sprintf(buff, "Cell %d - %d", ii/nc, ii%nc);
	lbl = new CmLabel(table, buff,  FIXED_MEDIUM);
	lbl->setShadow(WS_SHADOW_IN, 1, 0);
	lbl->setAlignment((ii%nc) ? LEFT_ALIGN : RIGHT_ALIGN);
    }

    table->showGrid();
    table->setColAlign(0, LEFT_ALIGN);
    table->setColAlign(3, RIGHT_ALIGN);
    table->setColFont(1, TIMES_LARGE);
    table->setColBackgroundRGB(3, 0, 255, 255);
    table->setColForegroundRGB(2, 255, 255, 255);

/*
 * Create a SFILE Object to view this source file in the dialog
 */
    sfile = new CmSFile(shell, __FILE__, FIXED_MEDIUM, 10, 48);
    sfile->setColor(darkblue, white);

    CmForm *form = new CmColForm(shell);
/*
 * This PUSH BUTTON closes the dialog
 */
    pb = new CmPushButton(form, "Clear", TIMES_MEDIUM);
    pb->setCallback(this, (VOID_CB)&TableFormDialog::clearTable);
    pb = new CmPushButton(form, "Add Rows", TIMES_MEDIUM);
    pb->setCallback(this, (VOID_CB)&TableFormDialog::addRows);
    pb = new CmPushButton(form, "Close", TIMES_MEDIUM);
    pb->setCallback(this, (VOID_CB)&TableFormDialog::closeDialog);

    shell->realize();
}

/*****************************************************
 *	This callback opens the dialog when the
 *	corresponding menu item is selected
 *****************************************************/
void
TableFormDemo(void)
{
	new TableFormDialog;
}
