@echo off
rem Generic batch file to build a version of the library. This batch file
rem assumes that the correct batch files exist to setup the appropriate
rem compilation environments, and that the DMAKE.EXE program is available
rem somewhere on the path.
rem
rem If you specify the parameter 'copy' first on the command line, the
rem object files wil be copied in and out of temporary directories so that
rem you can re-build a bunch of libraries quickly without needing to do
rem a full re-compile (this takes up a _lot_ of space however!). If the
rem directories do not exist, they are created.
rem
rem Version for Windows DOS boxes that does not load and remove 32rtm

rem Unset all environment variables that change the compile process
set DBG=
set OPT=
set OPT_SIZE=
set BUILD_DLL=
set IMPORT_DLL=
set FPU=
set CHECKS=

rem Check if the copy command is first, and if so shift it into %0
if %1==copy shift

if %1==all goto doall
if %1==bc3 goto bc3
if %1==bc16 goto bc16
if %1==bc32 goto bc32
if %1==vc16 goto vc16
if %1==vc32 goto vc32
if %1==sc16 goto sc16
if %1==sc32 goto sc32
if %1==wc16 goto wc16
if %1==wc32 goto wc32
if %1==hc32 goto hc32
if %1==dj32 goto dj32
if %1==bc16w goto bc16w
if %1==bc32w goto bc32w
if %1==vc16w goto vc16w
if %1==vc32w goto vc32w
if %1==sc16w goto sc16w
if %1==sc32w goto sc32w
if %1==wc16w goto wc16w
if %1==wc32w goto wc32w

echo Usage: BUILD [copy] compiler_name [DMAKE commands]
echo.
echo Current compilers:                                    Extenders:
echo    bc3            - Borland C++ 3.1 16 bit
echo    bc16, bc16w    - Borland C++ 4.5 16 bit
echo    bc32, bc32w    - Borland C++ 4.5 32 bit            (DPMI32,TNT)
echo    vc16, vc16w    - Microsoft Visual C++ 1.5 16 bit
echo    vc32, vc32w    - Microsoft Visual C++ 1.0 32 bit   (TNT)
echo    sc16, sc16w    - Symantec C++ 6.1 16 bit
echo    sc32, sc32w    - Symantec C++ 6.1 32 bit           (DOSX,TNT,X-32)
echo    wc16, wc16w    - Watcom C++ 10.0 16 bit
echo    wc32, wc32w    - Watcom C++ 10.0 32 bit            (DOS4GW,TNT,X-32)
rem echo    hc32       - Metaware High C++ 3.21 32 bit     (TNT)
rem echo    dj32       - DJGPP port of GNU C++ 32 bit      (GO32)
echo.
echo This batch file will build all libraries with full optimisations
echo turned on. If you specify 'all' all compiler versions will be built.
echo You can pass commands to DMAKE.EXE on the command line. You can set the
echo following evironment variable to change the default DOS extender:
echo    USE_TNT=1    - Use Phar Lap TNT DOS Extender
echo    USE_X32=1    - Use FlashTek X-32 DOS Extender
echo    USE_X32VM=1  - Use FlashTek X-32VM DOS Extender
echo    USE_PMW=1    - Use PMODE/W DOS Extender
goto end

:doall

rem -------------------------------------------------------------------------
rem Compile for Borland C++ 3.1 16 bit library

:bc3
call bc3-dos.bat
dmake cleanexe
if NOT %0==copy goto bc3copied
if NOT EXIST bc3 mkdir bc3
copy bc3\*.obj
:bc3copied
dmake install %2 %3 %4 %5 %6 %7 %8 %9
if NOT %0==copy goto bc3done
copy *.obj bc3
:bc3done
if errorlevel 1 goto errorend
if not %1==all goto done

rem -------------------------------------------------------------------------
rem Compile for Borland C++ 4.5 16 bit library

:bc16
call bc16-dos.bat
dmake cleanexe
if NOT %0==copy goto bc16copied
if NOT EXIST bc16 mkdir bc16
copy bc16\*.obj
:bc16copied
dmake install %2 %3 %4 %5 %6 %7 %8 %9
if NOT %0==copy goto bc16done
copy *.obj bc16
:bc16done
if errorlevel 1 goto errorend
if not %1==all goto done

rem -------------------------------------------------------------------------
rem Compile for Borland C++ 4.5 16 bit windows

:bc16w
call bc16-win.bat
dmake cleanexe
if NOT %0==copy goto bc16wcopied
if NOT EXIST bc16w mkdir bc16w
copy bc16w\*.obj
:bc16wcopied
dmake install %2 %3 %4 %5 %6 %7 %8 %9
if NOT %0==copy goto bc16wdone
copy *.obj bc16w
:bc16wdone
if errorlevel 1 goto errorend
if not %1==all goto done

rem -------------------------------------------------------------------------
rem Compile for Borland C++ 4.5 32 bit library

:bc32
if %USE_TNT%==1 goto bc32tnt
call bc32-dos.bat
goto dobc32
:bc32tnt
call bc32-tnt.bat
:dobc32
dmake cleanexe
if NOT %0==copy goto bc32copied
if NOT EXIST bc32 mkdir bc32
copy bc32\*.obj
:bc32copied
dmake install %2 %3 %4 %5 %6 %7 %8 %9
if NOT %0==copy goto bc32done
copy *.obj bc32
:bc32done
if errorlevel 1 goto errorend
if not %1==all goto done

rem -------------------------------------------------------------------------
rem Compile for Borland C++ 4.5 32 bit Windows

:bc32w
call bc32-win.bat
dmake cleanexe
if NOT %0==copy goto bc32wcopied
if NOT EXIST bc32w mkdir bc32w
copy bc32w\*.obj
:bc32wcopied
dmake install %2 %3 %4 %5 %6 %7 %8 %9
if NOT %0==copy goto bc32wdone
copy *.obj bc32w
:bc32wdone
if errorlevel 1 goto errorend
if not %1==all goto done

rem -------------------------------------------------------------------------
rem Compile for Microsoft Visual C++ 1.5 16 bit library

:vc16
call vc16-dos.bat
dmake cleanexe
if NOT %0==copy goto vc16copied
if NOT EXIST vc16 mkdir vc16
copy vc16\*.obj
:vc16copied
dmake install %2 %3 %4 %5 %6 %7 %8 %9
if NOT %0==copy goto vc16done
copy *.obj vc16
:vc16done
if errorlevel 1 goto errorend
if not %1==all goto done

rem -------------------------------------------------------------------------
rem Compile for Microsoft Visual C++ 1.5 16 bit Windows

:vc16w
call vc16-win.bat
dmake cleanexe
if NOT %0==copy goto vc16wcopied
if NOT EXIST vc16w mkdir vc16w
copy vc16w\*.obj
:vc16wcopied
dmake install %2 %3 %4 %5 %6 %7 %8 %9
if NOT %0==copy goto vc16wdone
copy *.obj vc16w
:vc16wdone
if errorlevel 1 goto errorend
if not %1==all goto done

rem -------------------------------------------------------------------------
rem Compile for Microsoft Visual C++ 1.0 32 bit library

:vc32
call vc32-dos.bat
dmake cleanexe
if NOT %0==copy goto vc32copied
if NOT EXIST vc32 mkdir vc32
copy vc32\*.obj
:vc32copied
dmake install %2 %3 %4 %5 %6 %7 %8 %9
if NOT %0==copy goto vc32done
copy *.obj vc32
:vc32done
if errorlevel 1 goto errorend
if not %1==all goto done

rem -------------------------------------------------------------------------
rem Compile for Microsoft Visual C++ 1.0 32 bit Windows

:vc32w
call vc32-win.bat
dmake cleanexe
if NOT %0==copy goto vc32wcopied
if NOT EXIST vc32w mkdir vc32w
copy vc32w\*.obj
:vc32wcopied
dmake install %2 %3 %4 %5 %6 %7 %8 %9
if NOT %0==copy goto vc32wdone
copy *.obj vc32w
:vc32wdone
if errorlevel 1 goto errorend
if not %1==all goto done

rem -------------------------------------------------------------------------
rem Compile for Symantec C++ 6.1 16 bit library

:sc16
call sc16-dos.bat
dmake cleanexe
if NOT %0==copy goto sc16copied
if NOT EXIST sc16 mkdir sc16
copy sc16\*.obj
:sc16copied
dmake install %2 %3 %4 %5 %6 %7 %8 %9
if NOT %0==copy goto sc16done
copy *.obj sc16
:sc16done
if errorlevel 1 goto errorend
if not %1==all goto done

rem -------------------------------------------------------------------------
rem Compile for Symantec C++ 6.1 16 bit Windows

:sc16w
call sc16-win.bat
dmake cleanexe
if NOT %0==copy goto sc16copied
if NOT EXIST sc16w mkdir sc16w
copy sc16w\*.obj
:sc16wcopied
dmake install %2 %3 %4 %5 %6 %7 %8 %9
if NOT %0==copy goto sc16wdone
copy *.obj sc16w
:sc16wdone
if errorlevel 1 goto errorend
if not %1==all goto done

rem -------------------------------------------------------------------------
rem Compile for Symantec C++ 6.1 32 bit library

:sc32
if %USE_TNT%==1 goto sc32tnt
if %USE_X32%==1 goto sc32x32
call sc32-dos.bat
goto dosc32
:sc32tnt
call sc32-tnt.bat
goto dosc32
:sc32x32
call sc32-x32.bat
:dosc32
dmake cleanexe
if NOT %0==copy goto sc32copied
if NOT EXIST sc32 mkdir sc32
copy sc32\*.obj
:sc32copied
dmake install %2 %3 %4 %5 %6 %7 %8 %9
if NOT %0==copy goto sc32done
copy *.obj sc32
:sc32done
if errorlevel 1 goto errorend
if not %1==all goto done

rem -------------------------------------------------------------------------
rem Compile for Symantec C++ 6.1 32 bit Windows

:sc32w
call sc32-win.bat
dmake cleanexe
if NOT %0==copy goto sc32wcopied
if NOT EXIST sc32w mkdir sc32w
copy sc32w\*.obj
:sc32wcopied
dmake install %2 %3 %4 %5 %6 %7 %8 %9
if NOT %0==copy goto sc32wdone
copy *.obj sc32w
:sc32wdone
if errorlevel 1 goto errorend
if not %1==all goto done

rem -------------------------------------------------------------------------
rem Compile for Watcom C++ 10.0 16 bit library

:wc16
call wc16-dos.bat
dmake cleanexe
if NOT %0==copy goto wc16copied
if NOT EXIST wc16 mkdir wc16
copy wc16\*.obj
:wc16copied
dmake install %2 %3 %4 %5 %6 %7 %8 %9
if NOT %0==copy goto wc16done
copy *.obj wc16
:wc16done
if errorlevel 1 goto errorend
if not %1==all goto done

rem -------------------------------------------------------------------------
rem Compile for Watcom C++ 10.0 16 bit Windows

:wc16w
call wc16-win.bat
dmake cleanexe
if NOT %0==copy goto wc16wcopied
if NOT EXIST wc16w mkdir wc16w
copy wc16w\*.obj
:wc16wcopied
dmake install %2 %3 %4 %5 %6 %7 %8 %9
if NOT %0==copy goto wc16wdone
copy *.obj wc16w
:wc16wdone
if errorlevel 1 goto errorend
if not %1==all goto done

rem -------------------------------------------------------------------------
rem Compile for Watcom C++ 10.0 32 bit library

:wc32
if %USE_TNT%==1 goto wc32tnt
if %USE_X32%==1 goto wc32x32
call wc32-dos.bat
goto dowc32
:wc32tnt
call wc32-tnt.bat
goto dowc32
:wc32x32
call wc32-x32.bat
:dowc32
dmake cleanexe
if NOT %0==copy goto wc32copied
if NOT EXIST wc32 mkdir wc32
copy wc32\*.obj
:wc32copied
dmake install %2 %3 %4 %5 %6 %7 %8 %9
if NOT %0==copy goto wc32done
copy *.obj wc32
:wc32done
if errorlevel 1 goto errorend
if not %1==all goto done

rem -------------------------------------------------------------------------
rem Compile for Watcom C++ 10.0 32 bit Windows

:wc32w
call wc32-win.bat
dmake cleanexe
if NOT %0==copy goto wc32wcopied
if NOT EXIST wc32w mkdir wc32w
copy wc32w\*.obj
:wc32wcopied
dmake install %2 %3 %4 %5 %6 %7 %8 %9
if NOT %0==copy goto wc32wdone
copy *.obj wc32w
:wc32wdone
if errorlevel 1 goto errorend
if not %1==all goto done

rem -------------------------------------------------------------------------
rem Compile for Metaware High C++ 3.21 32 bit library

:hc32
call hc32-dos.bat
dmake cleanexe
if NOT %0==copy goto hc32copied
if NOT EXIST hc32 mkdir hc32
copy hc32\*.obj
:hc32copied
dmake install %2 %3 %4 %5 %6 %7 %8 %9
if NOT %0==copy goto hc32done
copy *.obj hc32
:hc32done
if errorlevel 1 goto errorend
if not %1==all goto done

rem -------------------------------------------------------------------------
rem Compile for DJGPP port of GNU C++ 32 bit library

:dj32
goto dj32done
call dj32-dos.bat
dmake cleanexe
if NOT %0==copy goto dj32copied
if NOT EXIST dj32 mkdir dj32
copy dj32\*.obj
:dj32copied
dmake install %2 %3 %4 %5 %6 %7 %8 %9
if NOT %0==copy goto dj32done
copy *.obj dj32
:dj32done
if errorlevel 1 goto errorend
if not %1==all goto done

:done
echo Done!
goto end
:errorend
echo *************************************************
echo * An error occurred while building the library. *
echo *************************************************
pause
:end
