/* yd_dot.h                     freeware                   xhunga@tiscali.fr  */

/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void rndv_uDv0F(
pmatrix mu,
pmatrix mv,
    int maxnumer,
    int maxdenom)
{
     int i;
     int j;
fraction InnerProduct;

   rndmF(mu,maxnumer,maxdenom);
   rndmF(mv,maxnumer,maxdenom);

       i = mu->rows - 1;
       j = mu->cols - 2;

     *(mu->pblock + i *mu->cols + j    ) = 0;
     *(mu->pblock + i *mu->cols + j + 1) = 1;

     *(mv->pblock + i *mv->cols + j    ) = 1;
     *(mv->pblock + i *mv->cols + j + 1) = 1;

   InnerProduct = innerprod(mu,mv);

     *(mu->pblock + i *mu->cols + j    ) = -InnerProduct.numer;
     *(mu->pblock + i *mu->cols + j + 1) =  InnerProduct.denom;
}

/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void rndv_uDv0I(
pmatrix mu,
pmatrix mv,
    int maxnumer)
{
     int i;
     int j;
fraction InnerProduct;

   rndmI(mu,maxnumer);
   rndmI(mv,maxnumer);

       i = mu->rows - 1;
       j = mu->cols - 2;

     *(mu->pblock + i *mu->cols + j    ) = 0;
     *(mv->pblock + i *mv->cols + j    ) = 1;

   InnerProduct = innerprod(mu,mv);

     *(mu->pblock + i *mu->cols + j    ) = -InnerProduct.numer;
}

