/* yrvlc.h                       freeware                  xhunga@tiscali.fr  */


/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void rndLC2vectRnI(
pmatrix mA)
{
fraction s;
     int n;

double pbc  [MXR][MXC*TWOCOL];matrix mc    ={MXR,MXC*TWOCOL,&pbc   [0][0]};
double pbsc1[MXR][MXC*TWOCOL];matrix msc1  ={MXR,MXC*TWOCOL,&pbsc1 [0][0]};
double pbsc2[MXR][MXC*TWOCOL];matrix msc2  ={MXR,MXC*TWOCOL,&pbsc2 [0][0]};
double pbc3 [MXR][MXC*TWOCOL];matrix mc3   ={MXR,MXC*TWOCOL,&pbc3  [0][0]};

           n = mA->rows;

     mc.rows=n;      mc.cols= TWOCOL;
   msc1.rows=n;    msc1.cols= TWOCOL;
   msc2.rows=n;    msc2.cols= TWOCOL;
    mc3.rows=n;     mc3.cols= TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
   mzero(mA);

   rndmI(&mc,6);copycolF(&mc,0,mA,0);s = rndFI(9);smultmF(s,&mc,&msc1);
   rndmI(&mc,6);copycolF(&mc,0,mA,1);s = rndFI(9);smultmF(s,&mc,&msc2);

   addmF(&msc1,&msc2,&mc3);
   copycolF(&mc3, 0, mA,((mA->cols)/2)-1);
}


/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void rndLC3vectRnI(
pmatrix mA)
{
fraction s;
     int n;

double pbc  [MXR][MXC*TWOCOL];matrix mc    ={MXR,MXC*TWOCOL,&pbc   [0][0]};
double pbsc1[MXR][MXC*TWOCOL];matrix msc1  ={MXR,MXC*TWOCOL,&pbsc1 [0][0]};
double pbsc2[MXR][MXC*TWOCOL];matrix msc2  ={MXR,MXC*TWOCOL,&pbsc2 [0][0]};
double pbsc3[MXR][MXC*TWOCOL];matrix msc3  ={MXR,MXC*TWOCOL,&pbsc3 [0][0]};
double pbc4 [MXR][MXC*TWOCOL];matrix mc4   ={MXR,MXC*TWOCOL,&pbc4  [0][0]};

           n = mA->rows;

     mc.rows=n;      mc.cols= TWOCOL;
   msc1.rows=n;    msc1.cols= TWOCOL;
   msc2.rows=n;    msc2.cols= TWOCOL;
   msc3.rows=n;    msc3.cols= TWOCOL;
    mc4.rows=n;     mc4.cols= TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
   mzero(mA);

   rndmI(&mc,6);copycolF(&mc,0,mA,0);s = rndFI(9);smultmF(s,&mc,&msc1);
   rndmI(&mc,6);copycolF(&mc,0,mA,1);s = rndFI(9);smultmF(s,&mc,&msc2);
   rndmI(&mc,6);copycolF(&mc,0,mA,2);s = rndFI(9);smultmF(s,&mc,&msc3);

   addmF(&msc1,&msc2,&mc);
   addmF(&mc,  &msc3,&mc4);

   copycolF(&mc4,0,mA,((mA->cols)/2)-1);
}


