/* .c                         freeware                 xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"

/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
aplsb_C(int n,int p)
{
int      i;
int      j;
fraction a;
fraction b;
fraction aplsb;

double pbC     [MXR][MXC*TWOCOL];matrix mC     ={MXR,MXC*TWOCOL,&pbC    [0][0]};
double pbaC    [MXR][MXC*TWOCOL];matrix maC    ={MXR,MXC*TWOCOL,&pbaC   [0][0]};
double pbbC    [MXR][MXC*TWOCOL];matrix mbC    ={MXR,MXC*TWOCOL,&pbbC   [0][0]};

double paplsb_C [MXR][MXC*TWOCOL];
matrix maplsb_C={MXR, MXC*TWOCOL,&paplsb_C[0][0]};
double paCplsbC [MXR][MXC*TWOCOL];
matrix maCplsbC={MXR, MXC*TWOCOL,&paCplsbC[0][0]};

double paplsb_C_mns_aCplsbC   [MXR][MXC*TWOCOL];
matrix maplsb_C_mns_aCplsbC    ={MXR,MXC*TWOCOL,&paplsb_C_mns_aCplsbC   [0][0]};

                    mC.rows=n;                   mC.cols=p*TWOCOL;
                    maC.rows=n;                  maC.cols=p*TWOCOL;
                    mbC.rows=n;                  mbC.cols=p*TWOCOL;
               maplsb_C.rows=n;             maplsb_C.cols=p*TWOCOL;
               maCplsbC.rows=n;             maCplsbC.cols=p*TWOCOL;

               maplsb_C_mns_aCplsbC.rows=n;
               maplsb_C_mns_aCplsbC.cols=p*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  a = rndFI(9);
  b = rndFI(9);

  rndmI(&mC,10);

  clrscrn();
  printf("                                                      ");
  printf("a = %.0f\n\n",a.numer);
  printf("                                                      ");
  printf("b = %.0f\n\n", b.numer);
  printf("                                                      C  :");
  printmI4(&mC);
  getchar();

  clrscrn();
  aplsb = addF(a,b);
  printf("                                      ");
  printf(" a + b = %.0f + (%.0f) = %.0f\n\n",a.numer,b.numer, aplsb.numer);
  printf("                                                       C :");
  printmI4( &mC);
  printf("                                                 (a+b)C :\n");
  smultmF(aplsb,&mC,&maplsb_C);
  printmI4(         &maplsb_C);
  getchar();

  clrscrn();
  printf("                                                      ");
  printf("a = %.0f\n\n", a.numer);
  printf("                                                       C :");
  printmI4( &mC);
  printf("                                                      aC :\n");
  smultmF(a,&mC,&maC);
  printmI4(     &maC);
  getchar();

  clrscrn();
  printf("                                                      ");
  printf("b = %.0f\n\n", b.numer);
  printf("                                                       C :");
  printmI4( &mC);
  printf("                                                      bC :\n");
  smultmF(b,&mC,&mbC);
  printmI4(     &mbC);
  getchar();


  clrscrn();
  printf("                                                     aC  :");
  printmI4(&maC);
  printf("                                                     bC  :");
  printmI4(&mbC);
  printf("\n                                                 (aC+bC) :");
  addmF(&maC,&mbC,&maCplsbC);
  printmI4(       &maCplsbC);
  getchar();

  clrscrn();
  printf("                                                 (a+c)C  :");
  printmI4(&maplsb_C);
  printf("\n                                                 (aC+bC) :");
  printmI4(       &maCplsbC);
  printf("\n                                      ((a+c)C) - (aC+bC) :");
  submF(&maplsb_C,&maCplsbC,&maplsb_C_mns_aCplsbC);
  printmI4(                 &maplsb_C_mns_aCplsbC);
}


void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n            (a+c)C = aC+bC                        ");
  printf("\n            **************                      \n");
  printf("\n The size of  mC         : 1x1 ... 5x5.         \n");
  printf("\n     ex : \"pji.exe\"                           \n");
  printf("\n You can choose the size :                      \n");
  printf("\n     ex : \"pji.exe 2 3\" -> 2x3                  ");
  printf("\n          \"pji.exe 1 5\" -> 1x5                  ");
  printf("\n          \"pji.exe 4 2\" -> 4x2                  ");
  printf("\n          \"pji.exe 5 5\" -> 5x5                  ");
  printf("\n\n                                                ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");
  getchar();
}


/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
int    p;

/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 4 && atoi(argv[1])&& atoi(argv[2]) && atoi(argv[3]) )
 {n = atoi(argv[1]); if( n > 5){n=5;}
  p = atoi(argv[2]); if( p > 5){p=5;} }
else
 {    n=rndpI(5);       p=rndpI(5); }
   if(n<1){n=1;}     if(p<1){p=1;}


  aplsb_C(n,p);


printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}












