/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"

/* ------------------------------ FUNCTION -------------------------  */
/* Do    :                                      */
/*                             */
/* Call  :                                                            */
/* Debug :
/* -------------------------------------------------------------------------- */
invB(int n)
{
double pbA      [n][n*TWOCOL];matrix mA        ={n,n*TWOCOL,&pbA      [0][0]};
double pbB      [n][n*TWOCOL];matrix mB        ={n,n*TWOCOL,&pbB      [0][0]};
double pbAmnsB  [n][n*TWOCOL];matrix mAmnsB    ={n,n*TWOCOL,&pbAmnsB  [0][0]};
double pTrpsA    [n][n*TWOCOL];matrix mTrpsA    ={n,n*TWOCOL,&pTrpsA    [0][0]};
double pTrpsB    [n][n*TWOCOL];matrix mTrpsB    ={n,n*TWOCOL,&pTrpsB    [0][0]};

double pTrps_AmnsB[n][n*TWOCOL];
matrix mTrps_AmnsB={n,n*TWOCOL,&pTrps_AmnsB[0][0]};

double pTrpsAmnsTrpsB[n][n*TWOCOL];
matrix mTrpsAmnsTrpsB={n,n*TWOCOL,&pTrpsAmnsTrpsB[0][0]};

double pTrps_AmnsB_mns_TrpsAmnsTrpsB[n][n*TWOCOL];
matrix mTrps_AmnsB_mns_TrpsAmnsTrpsB={n,n*TWOCOL,&pTrps_AmnsB_mns_TrpsAmnsTrpsB[0][0]};

/*-------------------------------- PROGRAM ---------------------------------- */
 randmF(&mA,9,4);
 randmF(&mB,9,4);

 clrscrn();
 printf("                                                         A :\n");
 printmF(&mA);
 printf("                                                         B :\n");
 printmF(&mB);
 printf("                                                     A - B :\n");
 submF(&mA,&mB,&mAmnsB);
 printmF(      &mAmnsB);
 getchar();

 clrscrn();
 printf("                                                    A - B  :\n");
 printmF(      &mAmnsB);
 printf("                                          transpose(A - B) :\n");
 transposeF(&mAmnsB,&mTrps_AmnsB);
 printmF(           &mTrps_AmnsB);
 getchar();

 clrscrn();
 printf("                                                        A  :\n");
 printmF(&mA);
 printf("                                              transpose(A) :\n");
 transposeF(&mA,&mTrpsA);
 printmF(       &mTrpsA);
 getchar();

 clrscrn();
 printf("                                                        B  :\n");
 printmF(&mB);
 printf("                                              transpose(B) :\n");
 transposeF(&mB,&mTrpsB);
 printmF(       &mTrpsB);
 getchar();


 clrscrn();
 printf("                                              transpose(A) :\n");
 printmF(&mTrpsA);
 printf("                                              transpose(B) :\n");
 printmF(&mTrpsB);
 printf("                               transpose(A) - transpose(B) :\n");
 submF(&mTrpsA,&mTrpsB,&mTrpsAmnsTrpsB);
 printmF(&mTrpsAmnsTrpsB);
 getchar();

 clrscrn();
 printf("                                          transpose(A - B) :\n");
 printmF(           &mTrps_AmnsB);
 printf("                               transpose(A) - transpose(B) :\n");
 printmF(&mTrpsAmnsTrpsB);
 printf("          transpose(A - B) - (transpose(A) - transpose(B)) :\n");
 submF(&mTrps_AmnsB,&mTrpsAmnsTrpsB, &mTrps_AmnsB_mns_TrpsAmnsTrpsB);
 printmF(&mTrps_AmnsB_mns_TrpsAmnsTrpsB);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n transpose(A - B) = (transpose(A) - transpose(B)) ");
  printf("\n ************************************************\n");
  printf("\n The size of mA : 2x2 ... 4x4.                  \n");
  printf("\n           ex : \"trpcf.exe\"                   \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"trpcf.exe 2\" -> mA 2x2         ");
  printf("\n                \"trpcf.exe 3\" -> mA 3x3         ");
  printf("\n                \"trpcf.exe 4\" -> mA 4x4         ");
  printf("\n                                                  ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
int    i;

  srand(time(&t));

  hello();

do
{
  if(argc ==2 && atoi(argv[1]))
    {
    n = atoi(argv[1]);
    if( n< 2){n=2;}
    if( n> 4){n=4;}
    }
  else
    {
    n = (int) fabs(randF(5));
    if(n<2){n=2;}
    }

  invB(n);
  printf("\n Press 'X' Return to stop\n");

} while(toupper(getchar())!='X');

  return 0;
}

