/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"


/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
invB(int n,int p,int q)
{
double pbA     [MXR][MXC*TWOCOL];matrix mA      ={MXR,MXC*TWOCOL,&pbA     [0][0]};
double pbB     [MXR][MXC*TWOCOL];matrix mB      ={MXR,MXC*TWOCOL,&pbB     [0][0]};
double pbAB    [MXR][MXC*TWOCOL];matrix mAB     ={MXR,MXC*TWOCOL,&pbAB    [0][0]};
double pTrpsA  [MXR][MXC*TWOCOL];matrix mTrpsA  ={MXR,MXC*TWOCOL,&pTrpsA  [0][0]};
double pTrpsB  [MXR][MXC*TWOCOL];matrix mTrpsB  ={MXR,MXC*TWOCOL,&pTrpsB  [0][0]};
double pTrps_AB[MXR][MXC*TWOCOL];matrix mTrps_AB={MXR,MXC*TWOCOL,&pTrps_AB[0][0]};

double pTrpsBTrpsA [MXR][MXC*TWOCOL];
matrix mTrpsBTrpsA={MXR, MXC*TWOCOL,&pTrpsBTrpsA[0][0]};

double pTrps_AB_mns_TrpsBTrpsA [MXR][MXC*TWOCOL];
matrix mTrps_AB_mns_TrpsBTrpsA={MXR, MXC*TWOCOL,&pTrps_AB_mns_TrpsBTrpsA[0][0]};

                     mA.rows=n;                   mA.cols=p*TWOCOL;
                     mB.rows=p;                   mB.cols=q*TWOCOL;
                    mAB.rows=n;                  mAB.cols=q*TWOCOL;

                 mTrpsA.rows=p;               mTrpsA.cols=n*TWOCOL;
                 mTrpsB.rows=q;               mTrpsB.cols=p*TWOCOL;

               mTrps_AB.rows=q;             mTrps_AB.cols=n*TWOCOL;

            mTrpsBTrpsA.rows=q;          mTrpsBTrpsA.cols=n*TWOCOL;

     mTrps_AB_mns_TrpsBTrpsA.rows=q;   mTrps_AB_mns_TrpsBTrpsA.cols=n*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
 rndmF(&mA,9,4);
 rndmF(&mB,9,4);

 clrscrn();
 printf("                                                         A :\n");
 printmF(&mA);
 printf("                                                         B :\n");
 printmF(&mB);
 printf("                                                        AB :\n");
 multmF(&mA,&mB,&mAB);
 printmF(       &mAB);
 getchar();

 clrscrn();
 printf("                                                       AB  :\n");
 printmF(   &mAB);
 printf("                                             transpose(AB) :\n");
 transposeF(&mAB,&mTrps_AB);
 printmF(        &mTrps_AB);
 getchar();

 clrscrn();
 printf("                                                        A  :\n");
 printmF(&mA);
 printf("                                              transpose(A) :\n");
 transposeF(&mA,&mTrpsA);
 printmF(       &mTrpsA);
 getchar();

 clrscrn();
 printf("                                                        B  :\n");
 printmF(&mB);
 printf("                                              transpose(B) :\n");
 transposeF(&mB,&mTrpsB);
 printmF(       &mTrpsB);
 getchar();


 clrscrn();
 printf("                                              transpose(B) :\n");
 printmF(&mTrpsB);
 printf("                                              transpose(A) :\n");
 printmF(&mTrpsA);
 printf("                               transpose(B) * transpose(A) :\n");
 multmF(&mTrpsB,&mTrpsA,&mTrpsBTrpsA);
 printmF(&mTrpsBTrpsA);
 getchar();

 clrscrn();
 printf("                                             transpose(AB) :\n");
 printmF(           &mTrps_AB);
 printf("                               transpose(B) * transpose(A) :\n");
 printmF(&mTrpsBTrpsA);
 printf("             transpose(AB) - (transpose(B) * transpose(A)) :\n");
 submF(&mTrps_AB,&mTrpsBTrpsA, &mTrps_AB_mns_TrpsBTrpsA);
 printmF(&mTrps_AB_mns_TrpsBTrpsA);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n  transpose(AB) = (transpose(B) * transpose(A))   ");
  printf("\n  ********************************************  \n");
  printf("\n The size of mA : 2x2 ... 4x4.                  \n");
  printf("\n           ex : \"trpef.exe\"                   \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"trpef.exe 2\" -> mA 2x2         ");
  printf("\n                \"trpef.exe 3\" -> mA 3x3         ");
  printf("\n                \"trpef.exe 4\" -> mA 4x4         ");
  printf("\n                                                  ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
int    p;
int    q;
/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 4 && atoi(argv[1]) && atoi(argv[2]) && atoi(argv[3]) )
 {n = atoi(argv[1]); if( n > 5){n=5;}
  p = atoi(argv[2]); if( p > 5){p=5;}
  q = atoi(argv[2]); if( q > 5){q=5;}   }
else
 {    n=rndpI(5);   p=rndpI(5);   q=rndpI(5);  }
   if(n<2){n=2;} if(p<2){p=2;} if(q<2){q=2;}


  invB(n,p,q);


printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}

