/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"
#define mxr 4
#define mxc 4

/* ------------------------------ FUNCTION -------------------------  */
/* Do    :                                      */
/*                             */
/* Call  :                                                            */
/* Debug :
/* -------------------------------------------------------------------------- */
invAB(int n)
{
double pbA      [mxr][mxc*TWOCOL];  matrix mA      ={mxr,mxc*TWOCOL,&pbA       [0][0]};
double pbinvA   [mxr][mxc*TWOCOL];  matrix minvA   ={mxr,mxc*TWOCOL,&pbinvA    [0][0]};
double pbinvinvA[mxr][mxc*TWOCOL];  matrix minvinvA={mxr,mxc*TWOCOL,&pbinvinvA [0][0]};
double pbAID    [mxr][(mxc*2)*TWOCOL];matrix mAID  ={mxr,(mxc*2)*TWOCOL,&pbAID [0][0]};
double pbAIDT   [mxr][(mxc*2)*TWOCOL];matrix mAIDT ={mxr,(mxc*2)*TWOCOL,&pbAIDT[0][0]};
double pbT      [mxr][mxc*TWOCOL];  matrix mT      ={mxr,mxc*TWOCOL,&pbT       [0][0]};
double pbT2     [mxr][mxc*TWOCOL];  matrix mT2     ={mxr,mxc*TWOCOL,&pbT2      [0][0]};
double pbT3     [mxr][mxc*TWOCOL];  matrix mT3     ={mxr,mxc*TWOCOL,&pbT3      [0][0]};
double pbID     [mxr][mxc*TWOCOL];  matrix mID     ={mxr,mxc*TWOCOL,&pbID      [0][0]};
double pbIDT1   [mxr][mxc*TWOCOL];  matrix mIDT1   ={mxr,mxc*TWOCOL,&pbIDT1    [0][0]};
double pbIDT2   [mxr][mxc*TWOCOL];  matrix mIDT2   ={mxr,mxc*TWOCOL,&pbIDT2    [0][0]};

                     mA.rows=n;                  mA.cols=n*TWOCOL;
                  minvA.rows=n;               minvA.cols=n*TWOCOL;
               minvinvA.rows=n;            minvinvA.cols=n*TWOCOL;
                   mAID.rows=n;                mAID.cols=n*2*TWOCOL;
                  mAIDT.rows=n;               mAIDT.cols=n*2*TWOCOL;
                     mT.rows=n;                  mT.cols=n*TWOCOL;
                    mT2.rows=n;                 mT2.cols=n*TWOCOL;
                    mT3.rows=n;                 mT3.cols=n*TWOCOL;
                    mID.rows=n;                 mID.cols=n*TWOCOL;
                  mIDT1.rows=n;               mIDT1.cols=n*TWOCOL;
                  mIDT2.rows=n;               mIDT2.cols=n*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
 randmI(&mA,10);

 clrscrn();
 printf("                                                        A :\n");
 printmF(&mA);

/* invA */
 copymF(&mA,&mT3);
 mid(&mID);
 copymAID (&mA,&mID,&mAID);

 idF4(&mID,&mIDT1,&mIDT2,&mT,&mT2,&mA);
 multmF(&mID,&mAID,&mAIDT);
 multmF(&mID,&mT3,&mA);
 idF4a(&mID,&mIDT1,&mIDT2,&mT,&mT2,&mA);
 multmF(&mID,&mAIDT,&mAID);
 copyinv(&mAID, &minvA);

 printf("                                              inverse(A)  :\n");
 printmF(&minvA);
 copymF(&mT3,&mA);

/* minvinvA */
 copymF(&minvA,&mT3);
 mid(&mID);
 copymAID (&minvA,&mID,&mAID);

 idF4(&mID,&mIDT1,&mIDT2,&mT,&mT2,&minvA);
 multmF(&mID,&mAID,&mAIDT);
 multmF(&mID,&mT3,&minvA);
 idF4a(&mID,&mIDT1,&mIDT2,&mT,&mT2,&minvA);
 multmF(&mID,&mAIDT,&mAID);
 copyinv(&mAID, &minvinvA);

 printf("                                      inverse(inverse(A)) :\n");
 printmF(&minvinvA);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n         inverse(inverse(A)) = A                  ");
  printf("\n         ***********************                \n");
  printf("\n The size of mA : 2x2 ... 3x3.                  \n");
  printf("\n           ex : \"invai.exe\"                   \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"invai.exe 2\" -> mA 2x2         ");
  printf("\n                \"invai.exe 3\" -> mA 3x3         ");
  printf("\n                                                  ");
  printf("\n                                                  ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press a key to continue                          ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
int    i;

  srand(time(&t));

  hello();

do
{
  if(argc ==2 && atoi(argv[1]))
    {
    n = atoi(argv[1]);
    if( n> mxr){n=mxr;}
    }
  else
    {
    n = (int) fabs(randF(mxr));
    }

    if(n<2){n=2;}

  invAB(n);
  printf("\n Press 'X' Return to stop\n");

} while(toupper(getchar())!='X');

  return 0;
}

