/* myfmop.h                     freeware                   xhunga@tiscali.fr  */

/* ------------------------------ FUNCTION ------------------------ powermF() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void powmF(
pmatrix mA,
    int pn)
{
 int i;
 int n;

double pbT1 [MXR][MXC*TWOCOL];matrix mT1  ={MXR,MXC*TWOCOL,&pbT1 [0][0]};
double pbT2 [MXR][MXC*TWOCOL];matrix mT2  ={MXR,MXC*TWOCOL,&pbT2 [0][0]};

 n = mA->rows;
                   mT1.rows=n;                 mT1.cols=n*TWOCOL;
                   mT2.rows=n;                 mT2.cols=n*TWOCOL;

 if(!pn){mid(mA);}
 else
 {
  copymF(mA,&mT1);
  for(i = pn-1 ; i ; i--)
  {
   multmF(mA,&mT1,&mT2);
   copymF(&mT2,mA);
  }
 }
}

/* ------------------------------ FUNCTION ------------------------ powermF() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void powermF(
pmatrix mA,
pmatrix mApn,
    int   pn)
{
 int i;
 int n;

double pbT1 [MXR][MXC*TWOCOL];matrix mT1  ={MXR,MXC*TWOCOL,&pbT1 [0][0]};
double pbT2 [MXR][MXC*TWOCOL];matrix mT2  ={MXR,MXC*TWOCOL,&pbT2 [0][0]};

 n = mA->rows;
                   mT1.rows=n;                 mT1.cols=n*TWOCOL;
                   mT2.rows=n;                 mT2.cols=n*TWOCOL;

 copymF(mA,mApn);

 if(!pn){mid(mApn);}
 else
 {
  copymF(mApn,&mT1);
  for(i = pn-1 ; i ; i--)
  {
   multmF(mApn,&mT1,&mT2);
   copymF(&mT2,mApn);
  }
 }
}

