/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"

/* ------------------------------ FUNCTION -------------------------  */
/* Do    :                                      */
/*                             */
/* Call  :                                                            */
/* Debug :
/* -------------------------------------------------------------------------- */
invb(int n)
{
int x;
int p = n + 1;
int m = n - 1;

double pbA    [n][n*TWOCOL]; matrix mA     ={n,n*TWOCOL,&pbA    [0][0]};
double pbInvA [n][n*TWOCOL]; matrix mInvA  ={n,n*TWOCOL,&pbInvA [0][0]};
double pbb1   [n][  TWOCOL]; matrix mb1    ={n,  TWOCOL,&pbb1   [0][0]};
double pbb2   [n][  TWOCOL]; matrix mb2    ={n,  TWOCOL,&pbb2   [0][0]};
double pbA_b1 [n][p*TWOCOL]; matrix mA_b1  ={n,p*TWOCOL,&pbA_b1 [0][0]};
double pbA_b2 [n][p*TWOCOL]; matrix mA_b2  ={n,p*TWOCOL,&pbA_b2 [0][0]};
double pbb1_b2[n][2*TWOCOL]; matrix mb1_b2 ={n,2*TWOCOL,&pbb1_b2[0][0]};
double pTb1_b2[n][2*TWOCOL]; matrix mTb1_b2={n,2*TWOCOL,&pTb1_b2[0][0]};
double pbT1   [m][m*TWOCOL]; matrix mT1    ={m,m*TWOCOL,&pbT1   [0][0]};
double pbT2   [n][n*TWOCOL]; matrix mT2    ={n,n*TWOCOL,&pbT2   [0][0]};

/*-------------------------------- PROGRAM ---------------------------------- */
         x =  6;
 if(n<3){x = 25;}

  randmI(&mA, x);
  randmI(&mb1,x);
  randmI(&mb2,x);

  copymF(  &mA,   &mA_b1  );
  copycolF(&mb1,0,&mA_b1,n);
  copymF(  &mA,   &mA_b2  );
  copycolF(&mb2,0,&mA_b2,n);
  copycolF(&mb1,0,&mb1_b2,0);
  copycolF(&mb2,0,&mb1_b2,1);

  clrscrn();
  printf("\n Solving linear systems by matrix inversion : Ax = b1|b2\n");
  printf("\n A :\n");
  printmI(&mA);
  printf("\n b1 :\n");
  printmI(&mb1);
  printf("\n b2 :\n");
  printmI(&mb2);
  getchar();

  clrscrn();
  printf("\n                                 Inv(A) :\n");
  inverseF(&mA,&mT1,&mT2,&mInvA);
  printmF (              &mInvA);
  printf("\n                                  b1|b2 :\n");
  printmI(&mb1_b2);
  printf("\n         Ax = b1|b2 => x = Inv(A)*b1|b2 :\n");
  multmF(&mInvA,&mb1_b2,&mTb1_b2);
  printmF(              &mTb1_b2);
  getchar();

  clrscrn();
  printf("\n                       x = Inv(A)*b1|b2 :\n");
  printmF(&mTb1_b2);
  printf("\n                                   A|b1 :\n");
  printmI(&mA_b1);
  gaussjordanF(&mA_b1);
  printf("\n        Verify with GaussJordan on A|b1 :\n");
  printmIF(&mA_b1);
  getchar();

  clrscrn();
  printf("\n                       x = Inv(A)*b1|b2 :\n");
  printmF(&mTb1_b2);
  printf("\n                                   A|b2 :\n");
  printmI(&mA_b2);
  gaussjordanF(&mA_b2);
  printf("\n        Verify with GaussJordan on A|b2 :\n");
  printmIF(&mA_b2);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n                                                  ");
  printf("\n         Ax = b1|b2 => x = Inv(A)*b1|b2           ");
  printf("\n         ******************************         \n");
  printf("\n The size of mA : 2x2 ... 4x4.                  \n");
  printf("\n           ex : \"invz2I.exe\"                  \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"invz2I.exe 2\" -> mA 2x2        ");
  printf("\n                \"invz2I.exe 3\" -> mA 3x3        ");
  printf("\n                \"invz2I.exe 4\" -> mA 4x4        ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;
int    i;

  srand(time(&t));

  hello();

do
{
  if(argc ==2 && atoi(argv[1]))
    {
    n = atoi(argv[1]);
    if( n< 2){n=2;}
    if( n> 4){n=4;}
    }
  else
    {
    n = (int) fabs(randF(5));
    if(n<2){n=2;}
    }

  invb(n);
  printf("\n Press 'X' Return to stop\n");

} while(toupper(getchar())!='X');

  return 0;
}

