/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xahfile.h"

/* ------------------------------ FUNCTION -------------------------  */
/* Do    :                                      */
/*                             */
/* Call  :                                                            */
/* Debug :
/* -------------------------------------------------------------------------- */
gjA(
int n,
int Pn )
{
double pbA  [n][n*TWOCOL]; matrix mA  ={n,n*TWOCOL,&pbA  [0][0]};
double pbAT1[n][n*TWOCOL]; matrix mAT1={n,n*TWOCOL,&pbAT1[0][0]};
double pbAT2[n][n*TWOCOL]; matrix mAT2={n,n*TWOCOL,&pbAT2[0][0]};
/*-------------------------------- PROGRAM ---------------------------------- */

  clrscrn();
  mdiagF(&mA,9,3);
  printf("                                                 A      :\n");
  printmF5(&mA);
  printf("\n                                                  A**%d  :\n",Pn);
  powmF(&mA,&mAT1,&mAT2,Pn);
  printmF5(&mA);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France \n");
  printf("\n                                                  ");
  printf("\n         Powers of diagonal matrices :            ");
  printf("\n         ***************************              ");
  printf("\n                                                  ");
  printf("\n The size of mA : 2x2     6x6                     ");
  printf("\n The powers     :   0     5                     \n");
  printf("\n        ex : \"powdiagf exe\"                   \n");
  printf("\n You can choose the size :                      \n");
  printf("\n        ex : \"powdiagf exe 2 1\" -> mA(2x2)**1   ");
  printf("\n             \"powdiagf exe 3 5\" -> mA(3x3)**5   ");
  printf("\n             \"powdiagf exe 4 0\" -> mA(4x4)**0   ");
  printf("\n                                                  ");
  printf("\n Distributed  by :  http://www simtel net/        ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t  t;
int     n;
int    Pn;

  srand(time(&t));

  hello();

do
{
  if(argc ==3 && atoi(argv[1])&& atoi(argv[2]))
    {
    n  = atoi(argv[1]);
    Pn = atoi(argv[2]);

    if(  n < 1){ n = 1;}
    if(  n > 6){ n = 6;}
    if( Pn < 0){Pn = 0;}
    if( Pn > 5){Pn = 5;}
    }
  else
    {
    n  = (int) fabs(randF(7));
    if(n<1){n=1;}
    Pn = (int) fabs(randF(6));
    }

  gjA(n,Pn);
  printf("\n Press 'X' Return to stop\n");

} while(toupper(getchar())!='X');

  return 0;
}

