/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include "xa_hfile.h"

/* ------------------------------------- FUNCTION --------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
gjA(int n)
{
double pbA   [MXR][MXC*TWOCOL];matrix mA    ={MXR,MXC*TWOCOL,&pbA   [0][0]};
double pbD   [MXR][MXC*TWOCOL];matrix mD    ={MXR,MXC*TWOCOL,&pbD   [0][0]};
double pinvD [MXR][MXC*TWOCOL];matrix minvD ={MXR,MXC*TWOCOL,&pinvD [0][0]};
double pbL   [MXR][MXC*TWOCOL];matrix mL    ={MXR,MXC*TWOCOL,&pbL   [0][0]};
double pbU   [MXR][MXC*TWOCOL];matrix mU    ={MXR,MXC*TWOCOL,&pbU   [0][0]};
double pLinvD[MXR][MXC*TWOCOL];matrix mLinvD={MXR,MXC*TWOCOL,&pLinvD[0][0]};
double pbDU  [MXR][MXC*TWOCOL];matrix mDU   ={MXR,MXC*TWOCOL,&pbDU  [0][0]};
double pbT   [MXR][MXC*TWOCOL];matrix mT    ={MXR,MXC*TWOCOL,&pbT   [0][0]};

                     mA.rows=n;      mA.cols=n*TWOCOL;
                     mD.rows=n;      mD.cols=n*TWOCOL;
                  minvD.rows=n;   minvD.cols=n*TWOCOL;
                     mL.rows=n;      mL.cols=n*TWOCOL;
                     mU.rows=n;      mU.cols=n*TWOCOL;
                 mLinvD.rows=n;  mLinvD.cols=n*TWOCOL;
                    mDU.rows=n;     mDU.cols=n*TWOCOL;
                     mT.rows=n;      mT.cols=n*TWOCOL;
/*-------------------------------- PROGRAM ---------------------------------- */
  rndmI(&mA,5);

  clrscrn();
  printf("                                                       A :");
  printmI(&mA);
  LU(&mA,&mL,&mU);
  printf("                                                       L :");
  printmF3(&mL);
  printf("                                                       U :");
  printmF3(&mU);
  printf("                                                      LU :");
  multmF(&mL,&mU,&mT);
  printmI(&mT);
  getchar();

  clrscrn();
  printf("                                                       L :");
  printmF3(&mL);
  printf("                                             D = Diag(L) :");
  copydiagF(&mL,&mD);
  printmF3(     &mD);
  inverseF(&mD,&minvD);
  printf("                                                    invD :");
  printmF3(    &minvD);
  getchar();

  clrscrn();
  printf("                                                   LinvD :");
    multmF(&mL,&minvD,&mLinvD);
  printmF3(            &mLinvD);

  printf("                                                      DU :");
  multmF(&mD,&mU,&mDU);
  printmF3(      &mDU);

  printf("                                            A = LinvD DU :");
  multmF(&mLinvD,&mDU,&mT);
  printmI(           &mT);
  printf("                                                       A :");
  printmI(&mA);
}

void hello(void)
{
  printf("\n Freeware by : xhunga bernard 06000 Nice France.\n");
  printf("\n\n\n                                             ");
  printf("\n       LU decomposition are not unique.           ");
  printf("\n       *******************************        \n\n");
  printf("\n The size of mA : 2x2 ... 4x4.                  \n");
  printf("\n           ex : \"LUInot.exe\"                  \n");
  printf("\n You can choose the size :                      \n");
  printf("\n           ex : \"LUInot.exe 2\" -> mA 2x2        ");
  printf("\n                \"LUInot.exe 3\" -> mA 3x3        ");
  printf("\n                \"LUInot.exe 4\" -> mA 4x4        ");
  printf("\n\n                                                ");
  printf("\n Distributed  by :  http://www.simtel.net/        ");
  printf("\n                                                  ");
  printf("\n Press return to continue                          ");
  printf("\n                                                  ");

  getchar();
}

/* --------------------------------- MAIN ----------------------------------- */
main(int argc, char *argv[])
{
time_t t;
int    n;

/*-------------------------------- PROGRAM ---------------------------------- */
  srand(time(&t));
  hello();
do
{
if( argc == 2 && atoi(argv[1]))
 {  n = atoi(argv[1]); if( n > 4){n=4;}}
else
 {  n = rndpI(4);}
if( n < 2){n=2;}


  gjA(n);


printf("\n Press 'X' Return to stop\n");
} while(toupper(getchar())!='X');

  return 0;
}

