/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include <stdio.h>
#include <math.h>
#include "mydefine.h"
#include "mydata.h"
#include "myprint.h"     /* printm printrow printcol                          */
#include "mycopy.h"      /*  copym  copyrow  copycol                          */
#include "myspecm.h"     /* identity, zero matrix                             */
#include "myfmint.h"     /* rownmini divide a row by a integer if possible    */
#include "myelemrowop.h" /* Elementary row operations. swaprow multrow addrow */
#include "myfmop.h"      /* add, multiply two matrices. transpose             */
#include "myfpivot.h"    /* pivotntzero pivotwork                             */
#include "myfdet.h"      /* det, minor, cofactor, mcofactor, adjoint          */
#include "mygauss.h"     /* gauss gaussjordan                                 */
#include "myid.h"        /* gaussjordan(), inverse() with the identity matrix */
#include "myid2.h"       /* gaussjordan(), inverse() with the identity matrix */
#include "myid3.h"       /* gaussjordan(), inverse() with the identity matrix */
#include "myid4.h"       /* gaussjordan(), inverse() with the identity matrix */

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
 main()
{

double pblock[5][6*TWOCOL]=
{
-3,1,  4,1, -1,1,  0,1,  3,1,  2,1,
 2,1,  1,1,  2,1,  4,1,  0,1, -5,1,
 3,1, -2,1,  0,1, -1,1,  1,1, -3,1,
-2,1,  3,1,  2,1, -2,1,  2,1,  2,1,
 2,1, -1,1,  0,1,  2,1, -1,1,  5,1,
};
matrix m={5,6*TWOCOL,&pblock[0][0]};

double pblockT   [5][6*TWOCOL]; matrix mT    ={5,6*TWOCOL,&pblockT   [0][0]};
double pblockT2  [5][6*TWOCOL]; matrix mT2   ={5,6*TWOCOL,&pblockT2  [0][0]};
double pblockT3  [5][6*TWOCOL]; matrix mT3   ={5,6*TWOCOL,&pblockT3  [0][0]};
double pblockT4  [5][6*TWOCOL]; matrix mT4   ={5,6*TWOCOL,&pblockT4  [0][0]};

double pblockID  [5][5*TWOCOL]; matrix mID   ={5,5*TWOCOL,&pblockID  [0][0]};
double pblockIDT1[5][5*TWOCOL]; matrix mIDT1 ={5,5*TWOCOL,&pblockIDT1[0][0]};
double pblockIDT2[5][5*TWOCOL]; matrix mIDT2 ={5,5*TWOCOL,&pblockIDT2[0][0]};

/*-------------------------------- PROGRAM ---------------------------------- */
 copymF(&m,&mT3);
 copymF(&m,&mT4);

 printf("\n");
 printf(" The matrix  mA \n");
 printmF(&m);
  getchar();

 printf(" Find mID (below the pivots) \n");
 idF4(&mID,&mIDT1,&mIDT2,&mT,&mT2,&m);
 printmF(&mID);
 getchar();

 printf("  mID * mA  \n");
 multmF(&mID,&mT3,&m);
 printmF(&m);
 getchar();

 copymF(&m,&mT3);

 printf(" Find mID (above the pivots) \n");
 idF4a(&mID,&mIDT1,&mIDT2,&mT,&mT2,&m);
 printmF(&mID);
 getchar();

 printf("  mID * mA  \n");
 multmF(&mID,&mT3,&m);
 printmF(&m);
 getchar();

 printf(" Verify with gaussjordanF(); \n");
 copymF(&mT4,&m);
 gaussjordanF(&m);
 printmF(&m);

 printf("\n Press a key to continue");
 getchar();
}
