/* gjid03.c                         freeware                   xhunga@tiscali.fr
*/

/* --------------------------------- INCLUDES ------------------------------- */
#include <stdio.h>
#include <math.h>
#include "mydefine.h"
#include "mydata.h"
#include "myprint.h"     /* printm printrow printcol                          */
#include "mycopy.h"      /*  copym  copyrow  copycol                          */
#include "myspecm.h"     /* identity, zero matrix                             */
#include "myfmint.h"     /* rownmini divide a row by a integer if possible    */
#include "myelemrowop.h" /* Elementary row operations. swaprow multrow addrow */
#include "myfmop.h"      /* add, multiply two matrices. transpose             */
#include "myfpivot.h"    /* pivotntzero pivotwork                             */
#include "myfdet.h"      /* det, minor, cofactor, mcofactor, adjoint          */
#include "mygauss.h"     /* gauss gaussjordan                                 */
#include "myid.h"        /* gaussjordan(), inverse() with the identity matrix */
#include "myid2.h"       /* gaussjordan(), inverse() with the identity matrix */
#include "myid3.h"       /* gaussjordan(), inverse() with the identity matrix */

/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
/* ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++ */
 main()
{

double pblock[5][5*TWOCOL]=
{
1,1, 4,1, 3,1, 8,1, 7,1,
0,1, 1,1, 7,1, 5,1, 9,1,
0,1, 0,1, 1,1, 9,1, 7,1,
0,1, 0,1, 0,1, 1,1, 8,1,
0,1, 0,1, 0,1, 0,1, 1,1,
};
matrix m={5,5*TWOCOL,&pblock[0][0]};

double pblockAT [5][5*TWOCOL];  matrix mAT  = {5,5*TWOCOL,&pblockAT [0][0]};
double pblockT  [5][5*TWOCOL];  matrix mT   = {5,5*TWOCOL,&pblockT  [0][0]};

double pblockID [5][5*TWOCOL];  matrix mID  = {5,5*TWOCOL,&pblockID [0][0]};
double pblockIDT[5][5*TWOCOL];  matrix mIDT = {5,5*TWOCOL,&pblockIDT[0][0]};
double pblockID0[5][5*TWOCOL];  matrix mID0 = {5,5*TWOCOL,&pblockID0[0][0]};
double pblockID1[5][5*TWOCOL];  matrix mID1 = {5,5*TWOCOL,&pblockID1[0][0]};
double pblockID2[5][5*TWOCOL];  matrix mID2 = {5,5*TWOCOL,&pblockID2[0][0]};
double pblockID3[5][5*TWOCOL];  matrix mID3 = {5,5*TWOCOL,&pblockID3[0][0]};

/*-------------------------------- PROGRAM ---------------------------------- */
 printf(" The matrix mA \n");
 printmF(&m);
 copymF(&m,&mAT);

idF3a(&mID,&mT,&m,4);copymF(&mID,&mID0);printf("mID0");printmF(&mID0);getchar();
idF3a(&mID,&mT,&m,3);copymF(&mID,&mID1);printf("mID1");printmF(&mID1);getchar();
idF3a(&mID,&mT,&m,2);copymF(&mID,&mID2);printf("mID2");printmF(&mID2);getchar();
idF3a(&mID,&mT,&m,1);copymF(&mID,&mID3);printf("mID3");printmF(&mID3);getchar();

 printf("\n mID3 * mID2 : \n");
 multmF(&mID3, &mID2, &mID);
 printmF(&mID );
 getchar();

 printf("\n (mID3 * mID2) * mID1 : \n");
 multmF(&mID,  &mID1, &mIDT);
 printmF(&mIDT );
 getchar();

 printf("\n mID = ((mID3 * mID2) * mID1) * mID0 : \n");
 multmF(&mIDT, &mID0, &mID);
 printmF(&mID );
 getchar();

 copymF(&mAT,&m);
 printf("\n mID * mA : \n");
 multmF(&mID,&m,&mT);
 printmF(        &mT);

 printf("\n Press a key to continue");
 getchar();
}



