/* myfmop.h                     freeware                   xhunga@tiscali.fr  */

/* ------------------------------ FUNCTION --------------------------- addm() */
/*      add two matrices giving a third matrix    mOut = mIn1 + mIn2          */
/* -------------------------------------------------------------------------- */
int addmF(
pmatrix mIn1,
pmatrix mIn2,
pmatrix mOut)
{

     int i;
     int j;
fraction f;

  if (mIn1->rows != mIn2->rows || mIn1->cols != mIn2->cols)
    {
     printf("\n addm() error - matrices different sizes");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }
  if (mIn1->rows!=mOut->rows||mIn1->cols!=mOut->cols)
    {
     printf("\n addm() error - matrices different sizes");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }
  for (   i = 0; i < mIn1->rows ; i++)
    for ( j = 0; j < mIn1->cols ; j++, j++)
         {

                                              f.numer =   \

                 (*(mIn1->pblock + i *mIn1->cols + j) *   \
                 *(mIn2->pblock + i *mIn2->cols + j + 1))
                                    + \
                 *(mIn2->pblock + i *mIn2->cols + j)  *   \
                 *(mIn1->pblock + i *mIn1->cols + j + 1);

                                                f.denom = \

                *(mIn1->pblock + i *mIn1->cols + j + 1) * \
                *(mIn2->pblock + i *mIn2->cols + j + 1);

                 f = fminiF(f);

                *(mOut->pblock + i *mOut->cols + j)       = f.numer;
                *(mOut->pblock + i *mOut->cols + j + 1)   = f.denom;
         }
/*               printf("%8.1lf / %-8.1lf",
                            *(mIn1->pblock + i *mIn1->cols + j + 1),
                            *(mIn2->pblock + i *mIn2->cols + j + 1));
*/
  return(0);
}

/* ------------------------------ FUNCTION -------------------------- addf()  */
/* -------------------------------------------------------------------------- */
fraction addF(
fraction f1,
fraction f2)
{
  (f1.numer)=(f1.numer)*(f2.denom) + (f2.numer)*(f1.denom);
  (f1.denom)=(f1.denom)*(f2.denom);

  return(f1);
}


/* ------------------------------ FUNCTION -------------------------- multm() */
/*    mutiply two matrices giving a third matrix    mOut = mIn1 * mIn2        */
/* -------------------------------------------------------------------------- */
void multmF(
pmatrix mIn1,
pmatrix mIn2,
pmatrix mOut)
{
     int i;
     int j;
     int k;
fraction fm;
fraction fa;

              for(k= 0; k < mIn1->rows; k++)
               {
                  for(j= 0; j < mIn2->cols; j++,j++)
                   { fa.numer = 0;
                     fa.denom = 1;
                    for(i= 0; i < mIn1->cols; i++,i++)
                    {
                    fm.numer = *(mIn1->pblock +  k   *(mIn1->cols) + i )  * \
                               *(mIn2->pblock + i/2  *(mIn2->cols) + j ) ;

                    fm.denom = *(mIn1->pblock +  k   *(mIn1->cols) + i + 1) * \
                               *(mIn2->pblock + i/2  *(mIn2->cols) + j + 1);

                    fm = fminiF( fm);
                    fa = addF(fa,fm);
                    }
                     fa = fminiF(fa);

                     if(!fa.numer){fa.denom = 1;}

                     *(mOut->pblock +  k   *(mOut->cols) + j    ) = fa.numer;
                     *(mOut->pblock +  k   *(mOut->cols) + j + 1) = fa.denom;
                   }

               }
}

/* ------------------------------ FUNCTION ---------------------- transpose() */
/*                     */
/* -------------------------------------------------------------------------- */
int transposeF(
pmatrix mIn,
pmatrix mOut)
{
  int i;
  int j;

  if (mOut->rows * 2 != mIn->cols)
    {
     printf("\n transpose() error - dest matrix rows must = source matrix cols");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }
  if (mIn->rows * 2 != mOut->cols)
    {
     printf("\n transpose() error - source matrix rows must = dest matrix cols");
     printf("\n Press a key to continue");
     getchar();
     exit(1);
    }
  for (  i = 0 ; i < mIn->rows ;     i++)
   {
    for (j = 0 ; j < mIn->cols ; j++,j++)
      {
       *(mOut->pblock + (j/2) *mOut->cols + i * 2)     = \
       *( mIn->pblock +  i    *mIn->cols  + j    );

       *(mOut->pblock + (j/2) *mOut->cols + i * 2 + 1) = \
       *( mIn->pblock +  i     *mIn->cols + j     + 1);
      }
   }
  return(0);
}

