/* xxnpoly.h                    freeware                   xhunga@tiscali.fr  */

/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void mofpoly(

pmatrix mpxy,
pmatrix mOut)
{
   int i;
   int j;
   int p;

  for (   i = 0 ; i < mpxy->rows    ; i++)
   {
    p = mpxy->rows;
    for ( j = 0 ; j < mOut->cols-2; j++,j++)
     {
          *(mOut->pblock+i *mOut->cols+j  )        = \
      pow(*(mpxy->pblock+i *mpxy->cols    ),--p);
          *(mOut->pblock+i *mOut->cols+j+1)        = \
      pow(*(mpxy->pblock+i *mpxy->cols  +1),  p);
     }
     *(mOut->pblock+i *mOut->cols+j  )  = \
     *(mpxy->pblock+i *mpxy->cols  +2);
     *(mOut->pblock+i *mOut->cols+j+1)  = \
     *(mpxy->pblock+i *mpxy->cols  +3);
    }
}

/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void polyresultis(
pmatrix mOut)
{
int i;
int p = mOut->rows;

  printf("  y = ");
  for (   i = 0 ; i < mOut->rows    ; i++)
   {
    printf("(%.0f/%.0f)x**%d",
            *(mOut->pblock+i *mOut->cols+mOut->cols-2),
            *(mOut->pblock+i *mOut->cols+mOut->cols-1),
            --p);
    if(p){printf("+");}
   }
   printf("\n");
}

/* --------------------------------- FUNCTION ------------------------------  */
/* Do    :                                                                    */
/*                                                                            */
/* Call  :                                                                    */
/* Debug :                                                                    */
/* -------------------------------------------------------------------------- */
void calculate_y(
pmatrix mOut,
fraction fpoint)
{
int i;
int p = mOut->rows;
fraction fT;
fraction fT2;

fT2.numer = 0;
fT2.denom = 1;

  for (   i = 0 ; i < mOut->rows    ; i++)
   {
    fT.numer = *(mOut->pblock+i *mOut->cols+mOut->cols-2) * \
                     pow(fpoint.numer,--p);
    fT.denom = *(mOut->pblock+i *mOut->cols+mOut->cols-1) * \
                     pow(fpoint.denom,  p);

    fT2 = addF(fT2,fT);
   }

   printf(" With x =  %3.0f/%.0f,       y = %3.0f/%.0f \n",
           fpoint.numer,fpoint.denom,
              fT2.numer,   fT2.denom);
}

