/* myprint.h                    freeware                   xhunga@tiscali.fr  */


/* ------------------------------ FUNCTION ------------------------- printm() */
/*       *(mIn->pblock + i *mIn->cols + j)   print( row i column j )          */
/* -------------------------------------------------------------------------- */
void printmF(
pmatrix mIn)
{
 int i;
 int j;

 for (i = 0 ; i < mIn->rows ; i++)
  {
   printf("\n");
   for ( j = 0 ; j < mIn->cols ; j++,j++)
    {
     printf("%6.0lf/%-6.0lf",*(mIn->pblock + i *mIn->cols + j  ),
                             *(mIn->pblock + i *mIn->cols + j+1) );
    }
  }
  printf("\n");
}

/* ------------------------------ FUNCTION ------------------------- printm() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void printmF10(
pmatrix mIn)
{
 int i;
 int j;

 for (i = 0 ; i < mIn->rows ; i++)
  {
   printf("\n");
   for ( j = 0 ; j < mIn->cols ; j++,j++)
    {
     printf("%10.0lf/%-10.0lf",*(mIn->pblock + i *mIn->cols + j  ),
                             *(mIn->pblock + i *mIn->cols + j+1) );
    }
  }
  printf("\n");
}



/* ------------------------------ FUNCTION ------------------------- printm() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void printmF4(
pmatrix mIn)
{
 int i;
 int j;

 for (i = 0 ; i < mIn->rows ; i++)
  {
   printf("\n");
   for ( j = 0 ; j < mIn->cols ; j++,j++)
    {
     printf("%4.0lf/%-4.0lf",*(mIn->pblock + i *mIn->cols + j  ),
                             *(mIn->pblock + i *mIn->cols + j+1) );
    }
  }
  printf("\n");
}

/* ------------------------------ FUNCTION ------------------------- printm() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void printmF3(
pmatrix mIn)
{
 int i;
 int j;

 for (i = 0 ; i < mIn->rows ; i++)
  {
   printf("\n");
   for ( j = 0 ; j < mIn->cols ; j++,j++)
    {
     printf("%3.0lf/%-3.0lf",*(mIn->pblock + i *mIn->cols + j  ),
                             *(mIn->pblock + i *mIn->cols + j+1) );
    }
  }
  printf("\n");
}

/* ------------------------------ FUNCTION ------------------------- printm() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void printmF0(
pmatrix mIn)
{
 int i;
 int j;

 for (i = 0 ; i < mIn->rows ; i++)
  {
   printf("\n");
   for ( j = 0 ; j < mIn->cols ; j++,j++)
    {
     printf("%.0lf/%-.0lf ",*(mIn->pblock + i *mIn->cols + j  ),
                           *(mIn->pblock + i *mIn->cols + j+1) );
    }
  }
  printf("\n");
}


/* ------------------------------ FUNCTION ----------------------- printcol() */
/*                                                                            */
/* -------------------------------------------------------------------------- */
void printcolF(
pmatrix m,
int col)
{
  int i;

  for (i = 0 ; i < m->rows ; i++)
    {
     printf("\n");
     printf("%6.0lf/%-6.0lf",*(m->pblock + i *m->cols + col * TWOCOL    ),
                             *(m->pblock + i *m->cols + col * TWOCOL + 1) );
    }
  printf("\n");
}

/* ------------------------------ FUNCTION ---------------------- printrown() */
/*           *(m->pblock + rown *m->cols + j)   print the row  rown           */
/* -------------------------------------------------------------------------- */
void printrowF(
pmatrix m,
int rown)
{
  int j;

    printf("\n");
    for ( j = 0 ; j < m->cols ; j++ ,j++)
      {
         printf("%6.0lf/%-6.0lf",*(m->pblock + rown *m->cols + j      ),
                                 *(m->pblock + rown *m->cols + j + 1) );
      }
    printf("\n");
}

/* ------------------------------ FUNCTION ---------------------- printrown() */
/*           *(m->pblock + rown *m->cols + j)   print the row  rown           */
/* -------------------------------------------------------------------------- */
void printrowF10(
pmatrix m,
int rown)
{
  int j;

    printf("\n");
    for ( j = 0 ; j < m->cols ; j++ ,j++)
      {
         printf("%10.0lf/%-10.0lf",*(m->pblock + rown *m->cols + j      ),
                                 *(m->pblock + rown *m->cols + j + 1) );
      }
    printf("\n");
}



/* ------------------------------ FUNCTION ---------------------- printrown() */
/*           *(m->pblock + rown *m->cols + j)   print the row  rown           */
/* -------------------------------------------------------------------------- */
void printrowF4(
pmatrix m,
int rown)
{
  int j;

    printf("\n");
    for ( j = 0 ; j < m->cols ; j++ ,j++)
      {
         printf("%4.0lf/%-4.0lf",*(m->pblock + rown *m->cols + j      ),
                                 *(m->pblock + rown *m->cols + j + 1) );
      }
    printf("\n");
}

/* ------------------------------ FUNCTION ---------------------- printrown() */
/*           *(m->pblock + rown *m->cols + j)   print the row  rown           */
/* -------------------------------------------------------------------------- */
void printrowF3(
pmatrix m,
int rown)
{
  int j;

    printf("\n");
    for ( j = 0 ; j < m->cols ; j++ ,j++)
      {
         printf("%3.0lf/%-3.0lf",*(m->pblock + rown *m->cols + j      ),
                                 *(m->pblock + rown *m->cols + j + 1) );
      }
    printf("\n");
}

/* ------------------------------ FUNCTION ---------------------- printrown() */
/*           *(m->pblock + rown *m->cols + j)   print the row  rown           */
/* -------------------------------------------------------------------------- */
void printrowF0(
pmatrix m,
int rown)
{
  int j;

    printf("\n");
    for ( j = 0 ; j < m->cols ; j++ ,j++)
      {
         printf("%.0lf/%-.0lf ",*(m->pblock + rown *m->cols + j      ),
                               *(m->pblock + rown *m->cols + j + 1) );
      }
    printf("\n");
}

