#include <stdio.h>
#include <stdlib.h>
#include <io.h>
#include "mwutil.h"

int  _wscroll      = 1;
int  _conio_reinit = 0;

WORD  screen_seg   = 0xB800;
WORD  screen_start = 0;
WORD  screen_page  = 0;
WORD  CRT_base     = 0x3D4;
DWORD _linear_scr  = 0;

struct text_info conio_scr_info = { 0,0, 80,25, 7,7, 3, 25,80, 0,0 };

/*-----------------------------------------------------------------------*/

static BYTE __getvideomode (void)
{
  BYTE mode = __dosFp [0x449];
  if (mode == C80)               /* = mode 3 */
     if (__dosFp[0x484] > 24)
         mode = C4350;
  return (mode);
}

static void __gettextinfo (void)
{
  BYTE x = wherex();
  BYTE y = wherey();
  BYTE c = _scrFp [GetVideoOfs(x,y) + 1];
  conio_scr_info.currmode  = __getvideomode();
  conio_scr_info.attribute =
  conio_scr_info.normattr  = c ? c : LIGHTGRAY;
}

void gettextinfo (struct text_info *t)
{
  conio_init();
  *t = conio_scr_info;
}

/*-----------------------------------------------------------------------*/

#ifdef __NNANSI
#define NNANSI_SLOW "\x1B[?98l"
#define NNANSI_FAST "\x1B[?98h"
#define ERASE       "\b\b\b\b\b\b      \r"

static void nnansi_slow (void)
{
  /* Put NNANSI.SYS in slow-write mode to prevent cursor
   * positioning trouble.
   */
  write (fileno(stdout),NNANSI_SLOW,sizeof(NNANSI_SLOW));
}

static void nnansi_fast (void)
{
  BYTE x = wherex();
  write (fileno(stdout),NNANSI_FAST,sizeof(NNANSI_FAST));
  if (wherex() > x)
     write (fileno(stdout),ERASE,sizeof(ERASE));
}
#endif

/*-----------------------------------------------------------------------*/

void conio_init (void)
{
  static char is_init = 0;

  if (!is_init || _conio_reinit)
  {
    BYTE     w,h,y;
    SWI_REGS reg;
    BYTE     videoMode;

    FP_SET (__dosFp,0,SS_DOSMEM);
    CRT_base = __dosFp [0x463];
    reg.eax  = 0x0F00;
    _dx_real_int (0x10,&reg);
    videoMode    = loBYTE (reg.eax);
    screen_seg   = videoMode == MONO ? 0xB000 : 0xB800;
    screen_page  = hiBYTE (reg.ebx);
    screen_start = 0x1000 * screen_page;
    conio_scr_info.screenwidth  = w = hiBYTE (reg.eax);
    conio_scr_info.screenheight = h = 1 + __dosFp [0x484];
    conio_scr_info.wintop       = 1;
    conio_scr_info.winleft      = 1;
    conio_scr_info.winright     = w;
    conio_scr_info.winbottom    = h;

    for (y=0; y < sizeof(_lineOfs)/sizeof(_lineOfs[0]); y++)
        _lineOfs[y] = screen_start + ((y * w) << 1);

    if (!is_init)
    {
      is_init = 1;
#ifdef __NNANSI    /* Not worth it. nnansi_fast() may mess with the screen */
      nnansi_slow();
      atexit (nnansi_fast);
#endif
    }
    _conio_reinit = 0;
    _linear_scr   = screen_seg << 4;
    FP_SET (_scrFp,_linear_scr,SS_DOSMEM);
    __gettextinfo();
  }
}
