/*===================================================================
 integral.h

 Version 1.0

 Written by:
   Brent Worden
   WordenWare
   email:  brent@worden.org

 Copyright (c) 2000-2001 WordenWare

 Created:  January 7, 2000
 Revised:  
===================================================================*/

#ifndef _INTEGRAL_H_
#define _INTEGRAL_H_

#include "numerics.h"

typedef double (*Function)(double);

NUMERICS_EXPORT double simpsons(Function func, double a, double b, double tol, int nmax);
/*-------------------------------------------------------------------
 Returns an approximation to the integral of the function func from a
 to b.  The relative error of the approximation is no more than tol.
 nmax is the maximum number of iteration to perform to reach this
 error level.  Integration is performed using Simpson's rule.
-------------------------------------------------------------------*/

NUMERICS_EXPORT double trapezoid(Function func, double a, double b, double tol, int nmax);
/*-------------------------------------------------------------------
 Returns an approximation to the integral of the function func from a
 to b.  The relative error of the approximation is no more than tol.
 nmax is the maximum number of iteration to perform to reach this
 error level.  Integration is performed using the trapezoidal rule.
-------------------------------------------------------------------*/

#endif

/*===================================================================
 Revision History

 Version 1.0 - 01/07/2000 - New.
===================================================================*/
