/*
	ASCII.C - Display ASCII codes and characters
*/

#include <stdio.h>
#include <kbd.h>

void Ascii(void);
extern int Code;

extern int BorderClr;
extern int TitleClr;
extern int TextClr;
extern int FooterClr;

void Ascii()
{
	register int i;
	int Quit = 0;
	int x = 12, y = 6;
	int Oldx, Oldy;

	ScrGetCur(&Oldx, &Oldy, 0);
	ScrPush();
	HideCur();

	ShadowBox(x, 1, x+16, 22, 2, BorderClr);
	PutStr(x+1, 2, TitleClr, "  Ascii codes  ");
	PutStr(x,3, BorderClr,  "͵");
	PutStr(x+1,4, TextClr,   " Dec  Hex  Chr ");
	PutStr(x,5, BorderClr,  "͵");
	ClrScrn(x+1,6,x+15,21, TextClr);


	do	{
		y = 6;
		for (i=Code; y<22; ++i)	{
			if (i % 2)
				PutStr(x+1,y,  FooterClr, " %3d   %02X   %c  ", i, i, i);
			else
				PutStr(x+1,y,  TextClr, " %3d   %02X   %c  ", i, i, i);
			y++;
			if (Code == 0)   PutStr(x+13,  6, TextClr, " ");
			if (Code == 240) PutStr(x+13, 21, TextClr, " ");
		}

		switch (KbdGetC())	{
			case UP:    Code--;     break;
			case DN:    Code++;     break;
			case PGDN:
			case RIGHT: Code += 15; break;
			case PGUP:
			case LEFT:  Code -= 15; break;
			case HOME:  Code = 0;   break;
			case END:   Code = 240; break;
			case RET:
			case ESC:   Quit = 1;   break;
			default :				break;
		}
		if (Code > 240) Code = 0;
		if (Code < 0) Code = 240;
	} while (!Quit);

	ScrPop(1);
	ScrSetCur(Oldx, Oldy, 0);
	return;
}
