/*
	CLRCODES.C - Display the 255 Colors and their (hex) codes.
*/

#include <stdio.h>
#include <kbd.h>

void ColorCodes(void);

extern int ClrIdx;

extern int BorderClr;
extern int TitleClr;
extern int TextClr;
extern int FooterClr;

void ColorCodes()
{
	register int i, col, row, y;

	ScrPush();
	ShadowBox(6,0,71,13, 2, BorderClr);
	PutStr(33,1, TitleClr, " Color Codes ");
	PutStr(6,2,  BorderClr,
	"͵");
	PutStr(6,11, BorderClr,
	"͵");
	PutStr(7,12, FooterClr,
	 "     Press any key to toggle blinking colors    Esc - Quit      ");

	for (;;)	{
		col = 7; row = 3;
		for (i=ClrIdx; row<11; i++)	{
			PutStr(col, row, i, " %02X ", i);
			col += 4;
			if (col >= 70)	{
				col=7;
				row++;
			}
		}

		switch (KbdGetC())	{
			case ESC:
				ScrPop(1);
				return;
			default:
				ClrIdx += 0x80;
				if (ClrIdx > 0x80) ClrIdx = 0x00;
				break;
		}
	}
}
