/***************************************************************/
/* File Id.                       Fonts.C                      */
/* Author.                        Stan Milam.                  */
/* Date Written.                  12 Dec 89                    */
/*                                                             */
/*           (c) Copyright 1989, 1990 by Stan Milam            */
/*                                                             */
/* Comments:  Routines to download EGA/VGA ROM fonts and to    */
/* load user fonts into EGA/VGA registers.                     */
/***************************************************************/

#include <stdio.h>
#include <dos.h>
#include "pcwproto.h"

void far Intr(int intno, struct REGPACK far *regs);

/***************************************************************/
/*                      download_rom_font()                    */
/*                                                             */
/* Download an 8x14 or 8x16 font into a buffer provided by the */
/* application programmer.                                     */
/* Buffer should be large enough to hold 256 * 14 or 256 * 16  */
/* Returns number of bytes per character, zero if function fail*/
/***************************************************************/

int download_rom_font(int font, char *buffer) {

   struct REGPACK regs;
   char far *temp;
   int  mxr, mxc;

   if (!chk_video_state(&mxc, &mxr)) return(0);
   if ((_adaptor < EGA) || (_adaptor < VGA && font == 16)) return(0);
   temp = (char far *) buffer;
   switch (font) {
      case 14 : regs.r_bx = 0x0200; break;
      case 16 : regs.r_bx = 0x0600; break;
      default : return(0);
   }
   regs.r_ax = 0x1130;
   Intr(0x10, (struct REGPACK far *) &regs);
   farcopy(temp, MK_FP(regs.r_es,regs.r_bp), font * 256);
   return(font);
}

/***************************************************************/
/*                       load_user_font()                      */
/*                                                             */
/* Load a user defined font pointed to by *buffer into EGA/VGA */
/* registers.  A mode reset will reload default font.  Parms   */
/* as follows:                                                 */
/*    bpc: bytes per character (14 or 16)                      */
/*    blk: video block to load font (usually 0)                */
/*  nchrs: number of chars in buffer.                          */
/*  fchar: first character of the font buffer                  */
/* *buffer:the font table, of course.                          */
/*                                                             */
/* Returns non-zero value if successful.                       */
/***************************************************************/

int load_user_font(int bpc,int blk,int nchrs,int fchar,char *buffer) {

   char far *temp;
   struct REGPACK regs;
   int mxr, mxc;

   if (!chk_video_state(&mxr,&mxc)) return(0);
   if (_adaptor < EGA) return(0);
   temp = (char far *) buffer;
   regs.r_ax = 0x1100;
   regs.r_bx = (bpc << 8) | blk;
   regs.r_cx = nchrs;
   regs.r_dx = fchar;
   regs.r_es = FP_SEG(temp);
   regs.r_bp = FP_OFF(temp);
   Intr(0x10, (struct REGPACK far *) &regs);
   return(1);
}

/* Some test code:  make 'a' be 'b' and 'b' to 'c' and so on...

void main(void) {

   int i, j, k, x, y;
   static char ftable[16*256];

   chk_video_state(&i,&j);
   if (_adaptor > CGA) {
      k = download_rom_font((_adaptor == EGA) ? 14 : 16, ftable);
      for (i = 'a'; i <= 'z'; i++) {
          j = i * k;
          x = j + k;
          while( j < x) {
              ftable[j] = ftable[j + k];
              j++;
          }
      }
      load_user_font(k,0,256,0,ftable);
   }
}
*/
