/***************************************************************/
/* File Id.                     PLMENU.C                       */
/* Author.                      Stan Milam.                    */
/* Date Written.                06 Oct 1990.                   */
/*                                                             */
/*              (c) Copyright 1990 by Stan Milam.              */
/*                                                             */
/* The code here will support a list menu.  A list menu is one */
/* where the menu selections are a list of strings and the menu*/
/* function returns an integer value indicating which string   */
/* value was selected.                                         */
/*                                                             */
/***************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "pcw.i"
#include "pcwproto.h"
#include "menu.h"
#include "keys.h"

/* Internal function prototypes */

static void move_bar_down  ( PICKLIST *menu, int flag );
static void move_bar_up    ( PICKLIST *menu, int flag );
static int  do_mouse_move  ( int row, int col, PICKLIST *menu);
/**/
/***************************************************************/
/*                       make_pick_list()                      */
/*                                                             */
/* This function will initialize the pick list menu by alloc-  */
/* ating a window, putting in the title, and putting as manu of*/
/* string selections in the pick list window as possible.      */
/*                                                             */
/* Returns: Pointer to window, or NULL for an error.           */
/*                                                             */
/***************************************************************/

WNDPTR *make_pick_list(PICKLIST *menu) {

     char     **wrk;
     MENU_WND *pwnd;
     int      row, cols, rows;
     int      urow, ucol, lrow, lcol;
     int      fcolor, bcolor, cfclr, cbclr;

     pwnd = &menu -> plwnd;

/*               functions yet to be written
     save_btype = get_border_type();
     get_border_color(&bfclr, &bbclr);
     get_title_color(&tfclr, &tbclr);
*/
     menu -> bar_pos = 0;
     urow = pwnd -> urow; ucol = pwnd -> ucol;
     lrow = pwnd -> lrow; lcol = pwnd -> lcol;
     fcolor = pwnd -> fcolor; bcolor = pwnd -> bcolor;
     cfclr = pwnd -> cfclr; cbclr = pwnd -> cbclr;

     setborder(pwnd->btype);
     titlecolor(pwnd->tfclr, pwnd->tbclr);
     bordercolor(pwnd->bfclr, pwnd->bbclr);

     pwnd -> wnd = wframe(urow, ucol, lrow, lcol, fcolor, bcolor);

     if (pwnd -> wnd == NULL) return ( NULL );

     urow = pwnd -> urow = pwnd->wnd->urow;
     ucol = pwnd -> ucol = pwnd->wnd->ucol;
     lrow = pwnd -> lrow = pwnd->wnd->lrow;
     lcol = pwnd -> lcol = pwnd->wnd->lcol;
     rows = (lrow - urow) - 1;

     wtitle(pwnd -> wnd, pwnd->tvloc, pwnd->thloc, pwnd->title);

     row = 1; wrk = &menu -> list[ menu -> off ];
     while ( *wrk && row <= rows ) {
           wputs(pwnd -> wnd, row, 2, *wrk);
           wrk++;
           row++;
     }

     cols = (pwnd -> lcol - pwnd -> ucol) - 1;
     w_chg_attr(pwnd->wnd, 1+menu->bar_pos,1, cfclr, cbclr,cols);
     qputchar(urow+1, ucol, pwnd -> bfclr, pwnd -> bbclr, 24);
     qputchar(urow+1, lcol, pwnd -> bfclr, pwnd -> bbclr, 25);

     return ( pwnd -> wnd );
}
/*  */
/***************************************************************/
/*                        get_pick_list()                      */
/*                                                             */
/* This function will handle the the actions of the user when  */
/* picking an item from the pick list.  Handles MOUSE and key- */
/* board action.                                               */
/*                                                             */
/* Returns: an integer value that is the ordinal value of the  */
/* positon of the item in the list, or -1 if ESC was pressed.  */
/*                                                             */
/***************************************************************/

int get_pick_list(PICKLIST *menu) {

    int  ch, flag;
    int  mrw, mcl, mstatus, off;
    MENU_WND *mwnd;

    mwnd = &menu -> plwnd;
    if (mpresent) hide_mouse();
    re_order(mwnd->wnd, NORMAL);
    if (mpresent) show_mouse();

    for(;;) {

          flag = 0;
          off = menu -> off;
          ch = readkey();
          switch ( ch ) {
                 case LEFT_MOUSE_KEY :
                    get_mpos(&mrw, &mcl, &mstatus);
                    if ((mstatus = do_mouse_move(mrw, mcl, menu)) > -1)
                        return (mstatus);
                    break;
                 case ESC            :
                 case RITE_MOUSE_KEY :
                    return -1;
                 case ENTER          :
                 case BOTH_MOUSE_KEY :
                    return off;
                  case PGDN          :
                    flag = 1;
                 case DOWNARROW      :
                    move_bar_down( menu, flag );
                    break;
                  case PGUP          :
                    flag = 1;
                 case UPARROW        :
                    move_bar_up( menu, flag );
                    break;
          }
    }
#ifndef __TURBOC__
      return ( 0 );
#endif
}
/**/
/***************************************************************/
/*                        move_bar_down()                      */
/*                                                             */
/* This code isolates the logic necessary to move the lightbar */
/* down or scroll the screen up, whatever is needed.           */
/*                                                             */
/* Returns: Nothing.                                           */
/*                                                             */
/***************************************************************/

static void move_bar_down( PICKLIST *menu, int flag ) {

     char     **wrk;
     WNDPTR   *wnd;
     MENU_WND *pwnd;
     int      barpos, off, rows, cols, lcnt;
     int      fcolor, bcolor, cfclr, cbclr, row;

/* Dereference everything to make it easier to work with */

     pwnd   = &menu -> plwnd;
     wrk    = menu -> list;
     barpos = menu -> bar_pos; off = menu -> off;
     cfclr  = pwnd -> cfclr; cbclr = pwnd -> cbclr;
     fcolor = pwnd -> fcolor; bcolor = pwnd -> bcolor;

     wnd = pwnd -> wnd;
     rows = (wnd -> lrow - wnd -> urow) - 1;
     cols = (wnd -> lcol - wnd -> ucol) - 1;
     if ( flag ) {
          for ( lcnt = -1; *wrk; wrk++, lcnt++);
          if ( off + rows - barpos > lcnt ) flag = 0;
     }
     if ( flag ) {
          if ( mpresent ) hide_mouse();
          off += rows - barpos;
          wrk = &menu -> list[ off ];
          clr_wnd( wnd, 1 );
          for ( row = 1; *wrk && row <= rows; wrk++, row++ )
                wputs( wnd, row, 2, *wrk);
          barpos = 0;
          w_chg_attr(wnd, barpos + 1, 1, cfclr, cbclr, cols);
     }
     else {
          wrk = menu -> list;
          if ( wrk[off + 1] == NULL ) return;
          off++;
          if (mpresent) hide_mouse();
          if ( barpos >= (rows-1)) {
              w_chg_attr(wnd, barpos + 1, 1, fcolor, bcolor, cols);
              wscroll(wnd, 1, -1);
              wputs(wnd, barpos + 1, 2, wrk[ off ]);
              w_chg_attr(wnd, barpos + 1, 1, cfclr, cbclr, cols);
          }
          else {
              barpos++;
              w_chg_attr(wnd, barpos, 1, fcolor, bcolor, cols);
              w_chg_attr(wnd, barpos + 1, 1, cfclr, cbclr, cols);
          }
     }
     menu -> off = off; menu -> bar_pos = barpos;
     if ( mpresent ) show_mouse();
}
/**/
/***************************************************************/
/*                       move_bar_up()                         */
/*                                                             */
/* This function isolates the code to move the lightbar up or  */
/* scrolling the list which ever occurs.                       */
/*                                                             */
/* Returns: Nothing.                                           */
/*                                                             */
/***************************************************************/

static void move_bar_up( PICKLIST *menu, int flag ) {

     char     **wrk;
     WNDPTR   *wnd;
     MENU_WND *pwnd;
     int      barpos, off, rows, cols,row;
     int      fcolor, bcolor, cfclr, cbclr;

/* Dereference everything to make it easier to work with */

     pwnd   = &menu -> plwnd;
     wrk    = menu -> list;
     off    = menu -> off;
     barpos = menu -> bar_pos;
     cfclr  = pwnd -> cfclr; cbclr = pwnd -> cbclr;
     fcolor = pwnd -> fcolor; bcolor = pwnd -> bcolor;

     wnd = pwnd -> wnd;
     rows = (wnd -> lrow - wnd -> urow) - 1;
     cols = (wnd -> lcol - wnd -> ucol) - 1;

     if ( flag )
         if ( off - barpos - rows < 0 ) flag = 0;
     if ( flag ) {
         if ( mpresent ) hide_mouse();
         off = off - barpos - rows;
         wrk = &menu -> list[ off ];
         clr_wnd( wnd, 1 );
         for ( row = 1; *wrk && row <= rows; wrk++, row++ )
              wputs( wnd, row, 2, *wrk );
         barpos = 0;
         w_chg_attr( wnd, barpos+1, 1, cfclr, cbclr, cols );
     }
     else {
         if ( off < 1) return; else off--;
         if (mpresent) hide_mouse();
         if ( barpos ) {
             w_chg_attr(wnd,barpos+1,1,fcolor,bcolor,cols);
             w_chg_attr(wnd,barpos,1,cfclr,cbclr,cols);
             barpos--;
         }
         else {
             w_chg_attr(wnd,barpos+1,1,fcolor,bcolor,cols);
             wscroll(wnd,1,1);
             wputs(wnd,1,2,wrk[off]);
             w_chg_attr(wnd,barpos+1,1,cfclr,cbclr,cols);
         }
     }
     menu -> off = off;
     menu -> bar_pos = barpos;
     if ( mpresent ) show_mouse();
}
/**/
/***************************************************************/
/*                        do_mouse_move()                      */
/*                                                             */
/* This function isolates the code that moves the lightbar when*/
/* the mouse comes into play.  Will determine if an item has   */
/* been picked or if the user was moving the lightbar up or    */
/* down.                                                       */
/*                                                             */
/* Returns -1 if no selection, or a value >= 0 if a selection  */
/* was made.                                                   */
/*                                                             */
/***************************************************************/

static int do_mouse_move(int row, int col, PICKLIST *menu) {

     WNDPTR   *wnd;
     MENU_WND *pwnd;
     char     **wrk;
     int      lcount, mpos;
     int      barpos, off, cols;
     int      fcolor, bcolor, cfclr, cbclr;

/* Dereference everything to make it easier to work with */

     pwnd   = &menu -> plwnd;
     off    = menu -> off;
     barpos = menu -> bar_pos;
     cfclr  = pwnd -> cfclr; cbclr = pwnd -> cbclr;
     fcolor = pwnd -> fcolor; bcolor = pwnd -> bcolor;

     wnd = pwnd -> wnd;
     cols = (wnd -> lcol - wnd -> ucol) - 1;

     for(wrk = menu->list, lcount = -1; *wrk; wrk++, lcount++);

     if ((row > wnd -> urow && row < wnd -> lrow) &&
         (col > wnd -> ucol && col < wnd -> lcol)) {
         if (mpresent) hide_mouse();
         row -= wnd -> urow+1;
         mpos = row - barpos;
         if ( mpos ) {
            if ( off + mpos > lcount ) {
                 if (mpresent) show_mouse();
                 return ( -1 );
            }
            w_chg_attr(wnd,barpos+1,1,fcolor,bcolor,cols);
            barpos += mpos;
            w_chg_attr(wnd,barpos+1,1,cfclr,cbclr,cols);
            off += mpos;
         }
         menu -> off = off;
         menu -> bar_pos = barpos;
         if (mpresent) show_mouse();
         return ( off );
     }
     else if (row == wnd -> urow + 1) {
        if ( col == wnd -> ucol ) move_bar_up( menu, 0 );
        else if (col == wnd -> lcol) move_bar_down( menu, 0 );
     }
     return ( -1 );
}
