/***********************************************************/
/* File Id.                  Qhchar.C                      */
/* Author.                   Stan Milam.                   */
/* Date Written.             11/09/88.                     */
/* Date Last Modified.                                     */
/*                                                         */
/*           (c) Copyright 1989-90 by Stan Milam           */
/*                                                         */
/* Comments:  This function will repeatedly write a char-  */
/* acter to the screen horizontally.                       */
/***********************************************************/

#include <dos.h>
#include "pcw.i"
#include "pcwproto.h"

int qhchar(int row,int col,int fcolor,int bcolor, char ch, int count) {

   int page, pagesize;
   int mx_rows, mx_cols;
   int far *scrnptr;
   unsigned charattr;
   unsigned offset;
   unsigned scrnseg;

   if (!chk_video_state(&mx_rows,&mx_cols)) return(0);
   page     = getpage();
   pagesize = getpagesize();
   scrnseg  = getscrnseg();

   offset   = MK_SCRNOFF(row, col);
   charattr = MK_ATTR(fcolor, bcolor) | ch;
   scrnptr  = (int far *) MK_FP(scrnseg,offset);
   Thorzchar(count, charattr, scrnptr);
   return(1);
}
