/***********************************************************/
/* File Id.                  Randwnd.C                     */
/* Author.                   Stan Milam.                   */
/* Date Written.             09 Sep 89                     */
/*                                                         */
/* Comments:  Generate random windows around the screen    */
/* then move them around randomly until a key is pressed.  */
/* Notice there is no code in this program to remove the   */
/* windows:  We let the autoexit do it for us.             */
/***********************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <time.h>
#include <pcwproto.h>

#define MAXWND 20                      /* Max windows */
#define random(m) (rand() % (m))       /* Random number generator macro */
#define egacolor (_adaptor > CGA && _monitor == COLOR)

int main(void) {

   WNDPTR *wnd[MAXWND];                /* Array of window */
   int    fclr, bclr, r1, r2, c1, c2;  /* Colors & location */
   int    mxr, mxc, lcv;               /* Scratch Integers */
   long   timer;                       /* For seeding random numbers */

   fload(0,8);                          /* Load 8x8 font */
   srand(time(&timer));                 /* Seed random number generator */
   chk_video_state(&mxr, &mxc);         /* Get max rows & cols */
   for (lcv = 0; lcv < MAXWND; lcv++) { /* Put out MAXWND windows */
     r1 = random(mxr-6)+1;r2 = r1 + 6;  /* Generate rows */
     c1 = random(mxc-20)+1;c2 = c1 + 20;/* Generate columns */
     do {                               /* Make sure the background */
       fclr = random(15) + 1;           /*    and foreground are not equal */
       bclr = random(7)  + 1;
     } while (fclr == bclr);
     bordercolor(fclr, bclr);           /* Set border color */
     do {                               /* Make sure background color and */
       fclr = random(16);               /*    and foreground != */
       bclr = random(8);
     } while (fclr == bclr);
     wnd[lcv] = wframe(r1, c1, r2, c2, fclr, bclr);
     wprintf(wnd[lcv], 3,CENTER,"Window %02d",lcv+1);
   }
   while (!kbhit()) {                   /* Do until key is pressed */
       r1 = random(mxr - 6) + 1;        /* Randomly select row & column */
       c1 = random(mxc - 20) + 1;
       lcv= random(MAXWND);             /* Randomly select a window */
       wndmove(wnd[lcv], r1, c1);       /* Move it */
   } getch();                           /* Remove char from keyboard buffer */
   fload(0, (_adaptor == EGA) ? 14 : 16);
   return(0);
}
