
/************************************************************/
/* Module Id.                     Sound.C                   */
/* Author.                        Stan Milam.               */
/* Date Written.                  08/11/88.                 */
/*                                                          */
/*           (c) Copyright 1989-90 by Stan Milam            */
/*                                                          */
/* Comments: Two functions here - one to create a specified */
/* tone (sound()) and one to turn off the tone (nosound()). */
/************************************************************/

#include "pcwproto.h"

#ifdef MSC
#    include <conio.h>
#else
#    include <dos.h>
#endif

#define SOUNDPORT 0x61
#define TONEPORT  0x42

void _sound(unsigned freq) {

  short     i, j;

  freq = (unsigned) (1193182L / (long) freq);
  i    = freq & 0x00ff;
  j    = (freq & 0xff00) >> 8;
  outportb(TONEPORT, i); outportb(TONEPORT, j);
  outportb(SOUNDPORT, inportb(SOUNDPORT) | 0x3);
}

void _nosound(void) {
  outportb(SOUNDPORT, inportb(SOUNDPORT) & 0xfc);
}

