#ifndef __CONIO_H__
#define __CONIO_H__

#include <stddef.h>

struct text_info {
  unsigned char winleft;        /* left window coordinate */
  unsigned char wintop;         /* top window coordinate */
  unsigned char winright;       /* right window coordinate */
  unsigned char winbottom;      /* bottom window coordinate */
  unsigned char attribute;      /* text attribute */
  unsigned char normattr;       /* normal attribute */
  unsigned char currmode;       /* current video mode: (3)
  unsigned char screenheight;   /* text screen's height */
  unsigned char screenwidth;    /* text screen's width */
  unsigned char curx;           /* x-coordinate in current window */
  unsigned char cury;           /* y-coordinate in current window */
};  //for gettextinfo

#ifdef __cplusplus
  extern "C" {
#endif

extern word wherex(void);
extern word wherey(void);

extern byte getch(void);
extern word _getch(void);       //returns 0x100 + scan code if it's
                                // an extended key
extern byte getche(void);
extern void putch(byte);
extern byte kbhit(void);
extern byte key_tab;  // a 128byte array (scan code on =1 )
                      //   any key (grey or not) (key_tab1 OR key_tab2)
extern byte key_tab1;  // a 128byte array (scan code on =1 ) Non-grey keys 
extern byte key_tab2;  // a 128byte array (scan code on =1 ) Grey keys 
extern void key_block(byte x);

//ignore the benign errors from M$C for the follows functions : stupid M$C

extern sdword inp(word);
extern word inpw(word);
extern dword inpd(word);

extern sdword outp(word,sword);
extern word outpw(word,sword);
extern dword outpd(word,sdword);

extern void gotoxy(word x,word y);

extern void clrscr(void);
extern void setcursor(word scan);    //use _NOCURSOR
extern word getcursor(void);

extern void cputs(char *);
extern void cprintf(char *,...);
extern void cvprintf(char *,void *);
extern void window(dword,dword,dword,dword);
extern void textcolor(byte);
extern void textbackground(byte);
extern void textattr(byte);
extern void gettextinfo(struct text_info*);

#ifdef __cplusplus
  }
#endif

#define _NOCURSOR     0x0200
#define _SOLIDCURSOR  0x001f
#define _NORMALCURSOR 0x0d0e

#define inport inpw
#define outport outpw
#define inportb inp
#define outportb outp
#define inportd inpd
#define outportd outd

#if !defined(__COLORS)
#define __COLORS

enum COLORS {
  BLACK,                  /* dark colors */
  BLUE,
  GREEN,
  CYAN,
  RED,
  MAGENTA,
  BROWN,
  LIGHTGRAY,
  DARKGRAY,               /* light colors */
  LIGHTBLUE,
  LIGHTGREEN,
  LIGHTCYAN,
  LIGHTRED,
  LIGHTMAGENTA,
  YELLOW,
  WHITE
};
#endif

#define BLINK 128               /* blink bit */

#endif
