; QLIB's complete DPMI C callable functions.
;please see dpmi.h for better prototypes to look at

ifndef __DPMI_H__
__DPMI_H__ equ 0

.code

; 'C' wrappers  (see dpmi.txt for help)
_DPMI_wrapper_int proto :dword
_DPMI_wrapper_cb_retf proto :dword
_DPMI_wrapper_cb_iret proto :dword

; 20xh
_DPMI_getpmint proto :byte,:dword
_DPMI_setpmint proto :byte,:dword
_DPMI_getrmint proto :byte,:dword
_DPMI_setrmint proto :byte,:dword

; 303h and 304h
_DPMI_callback_alloc proto rf:dword,pf:dword,cb:dword
  ; rf = Rmode addr (returned)
  ; pf = Pmode addr (required)
  ; cb = callstruct (required)
_DPMI_callback_free proto rf:dword
  ; rf = Rmode addr (required)  (this was returned from callback_alloc())
externdef _DPMI_callback_iret:near
  ; Jmp here to end a callback PROC (iret stack frame)
  ; see dpmi.txt for more info
externdef _DPMI_callback_retf:near
  ; Jmp here to end a callback PROC (retf stack frame)
  ; see dpmi.txt for more info

_DPMI_phys_alloc proto loc:dword,siz:dword
_DPMI_phys_free proto loc:dword

_DPMI_lock_ram proto off:dword,siz:dword
_DPMI_unlock_ram proto off:dword,siz:dword
_DPMI_lock_all proto uselockonly:byte    ;returns amount locked

_DPMI_desc_alloc proto :word
_DPMI_desc_free proto :word
_DPMI_seg2desc proto :word
_DPMI_selinc proto
_DPMI_getbase proto :word
_DPMI_setbase proto :word,:dword
_DPMI_setlimit proto :word,:dword
_DPMI_setrights proto :word,:word
_DPMI_create_alias proto :word
_DPMI_getdesc proto :word,:dword
_DPMI_setdesc proto :word,:dword

_DPMI_dos_alloc proto :word
_DPMI_dos_free proto :word
_DPMI_dos_resize proto :word,:word

_DPMI_getexc proto :byte,:dword
_DPMI_setexc proto :byte,:dword
_DPMI_do_int proto :byte,:dword
_DPMI_do_call_retf proto :dword
_DPMI_do_call_iret proto :dword

_DPMI_get_raw_state proto :dword,:dword
_DPMI_get_raw_switch proto :dword,:dword

_DPMI_getver proto
_DPMI_getflgs proto
_DPMI_getcpu proto
_DPMI_getpics proto

_DPMI_cli proto
_DPMI_sti proto
_DPMI_getIF proto

; 0xeeff functions only
_DPMI_detect proto :dword
_DPMI_getmode proto

endif


