;this example uses pack_open()

include qlib.inc
include dos.inc
include string.inc
include stdio.inc
include process.inc

include data_hdr.asm

.data
  buf db 1024 dup (0)
  h dw ?
  siz dd ?
  ph dw ?  ;pack file handle
.code
main proc
  callp pack_open,"data.pak"
  .if eax==ERROR
    callp printf,"\npack_open() failed!\n"
    callp exit,0
  .endif
  mov ph,ax
  callp open,"file1",0
  mov h,ax
  .if eax==ERROR
    callp printf,"\nopen(file1) failed!\n"
    callp exit,0
  .endif
  callp lseek,h,0,SEEK_SET
  callp lseek,h,30,SEEK_CUR  ;lseeking with a pack file (skip over 1st line)
  callp filelength,h
  mov siz,eax
  callp read,h,offset buf,132
       ;filesiz=132 but we have lseek one byte over
       ;what will happen? pack.asm will cut it off so we
       ;don't start reading the next file.
  .if eax!=(132-30)
    callp printf,"error read eax=%d\n",eax
  .endif
  callp read,h,offset buf,100     ;try to read more : it will fail
  .if eax
    callp printf,"Error #2\n"
  .endif
  callp printf,"-=-=-=-=-=-=-=-=-=-=- FILE1 -=-=-=-=-=-=-=-=-=-=-\n"
  callp printf,offset buf
  callp printf,"-=-=-=-=-=-=-=-=-=-=- FILE1 -=-=-=-=-=-=-=-=-=-=-\n"
  callp eof,h
  .if eax
    callp printf,"EOF=true\n"
  .else
    callp printf,"EOF=false (bug?)\n"
  .endif
  callp printf,"File length of FILE1=%d\n",siz
  callp close,h

  callp pack_close,ph
       ;you can open many pack's if you want
       ;but I close this one so I can load the next (actually I doesn't
       ;matter since the pack system will use the most recently opened
       ;files first) And I wanna test this func anyway
  .if eax==ERROR
    callp printf,"\n pack_close() failed!\n"
    callp exit,0
  .endif
  callp pack_open,"data.pah",offset the_header
  .if eax==ERROR
    callp printf,"\n pack_open() failed!\n"
    callp exit,0
  .endif
  mov ph,ax

  callp open,"file2.",0
  mov h,ax
  .if ax==ERROR
    callp printf,"\nopen(file2) failed!\n"
    callp exit,0
  .endif
  callp read,h,offset buf,330
  callp close,h
  callp printf,"-=-=-=-=-=-=-=-=-=-=- FILE2 -=-=-=-=-=-=-=-=-=-=-\n"
  callp printf,offset buf
  callp printf,"\n-=-=-=-=-=-=-=-=-=-=- FILE2 -=-=-=-=-=-=-=-=-=-=-\n"
;some xtra lseek tests
  callp printf,"-=-=-=-=-=-=-=-=-= lseek Tests =-=-=-=-=-=-=-=-=-\n"
  callp lseek,h,0,SEEK_END
  callp printf," Pos 1=%i",eax
  callp lseek,h,303,SEEK_END
  callp printf," Pos 2=%i",eax
  callp lseek,h,304,SEEK_END
  callp printf," Pos 3=%i",eax
  callp lseek,h,-303,SEEK_CUR
  callp printf," Pos 4=%i",eax
  callp lseek,h,303,SEEK_SET
  callp printf," Pos 5=%i",eax
  callp lseek,h,-309,SEEK_CUR
  callp printf," Pos 6=%i",eax
  callp lseek,h,1,SEEK_END
  callp printf," Pos 7=%i",eax
  ret
main endp

end
