comment ~ 

  QDEBUG v1.10 now uses Q-DASM (which I wrote myself - which was based
  on Dazmit v1.03)

See DASM.ASM for help on it's usage.

~
;============================================================================
;
;
;   A routine that decodes an instrucion and outputs it in a string
;
;
;
;   FUNCTION:    Decode_instruction
;
;   EXPECTS:      ESI pointing to the instruction
;                 EDI pointing to the output string buffer
;
;   RETURNS:      EDI  pointing the the last character in the string
;                      (string also terminates with zero character).
;                 ESI  pointing to next instruction.
;
;=============================================================================

include dasm.inc

.data
  _regs_ dd 8 dup (?)

.code

Decode_instruction proc
  ;Must now prepare options for DASM

  push es
  push fs
  pushad

  push ds
  pop es

comment ~
  mov ebx,offset registers_save
  mov ecx,offset _regs_ + 7*4
  mov edx,8
@@:
  mov eax,[ebx]
  mov [ecx],eax  ;reverse order into PUSHAD order
  add ebx,4
  sub ecx,4
  dec dl
  jnz @b
~

  mov ecx,offset registers_save        ;DS:ECX = PUSHAD
  mov edx,registers_save.prg_eflags    ;EDX    = EFlags
  mov al,1   ;32bit mode               ;AL     = USE16(0)/USE32(1)
  mov fs,registers_save.prg_cs         ;FS:ESI = Code
                                       ;ES:EDI = String Output
  xor ebx,ebx                          ;EBX    = Program Base

  call DecodeOpcode

  mov [esp].callstruct._esi,esi
;  mov [esp].callstruct._ecx,ecx   ;can't use ECX
  popad
  pop fs
  pop es
  ret
Decode_instruction endp
