; This is the QDLL startup code. It's purpose is to copy
; the necessary tables (code jumptable and data pointer table)
; and then call the main function. Easy as eating pie.
; Note the two EQUs at the top of the file, and the fact that
; we don't include stuff like stdio.inc or malloc.inc .. pretty
; important fact. All the library functions we can use are defined
; in src\dlltab.inc. That also means we can't use ANY library functions
; before we have copied the two tables the DLL loader supplies us with.
; (done as one of the first things)

_DLL_CODE_  EQU 1   ; Required to keep certain stuff away
                    ; and make other stuff get in here :^)

include src\qlib.inc                   ; basic QLIB stuff
include src\dll.inc                    ; dll stuff
include dll.inc                        ; more DLL stuff
include src\dlltab.inc                 ; include funcs the DLL can call

.code

dll_init proc private,ver:dword,hnd:dword,__ctable:dword,__dtable:dword
; VER: DLL loader version
; HND: this DLLs handle (use for exporting symbols n stuff)
; __ctable: code jumptable (the right offsets, copy to our own)
; __dtable: data pointertable (the right offsets, copy to our own)

  cmp ver,DLL_VERSION
  je ok1                          ; version must be the EXACT same,
  mov eax,ERROR                   ; to avoid stupid errors
  ret
ok1:
  pushad                          ; save all reggies

  ; copy the code jumptable (making qlib funcs available)
  mov edi,offset __dll_codetable  ; copy to our table
  mov esi,__ctable
  mov ecx,DLL_CODETABLE_SIZE
  copyECX
  ; copy the data table (making qlib vars available thru pointers)
  mov edi,offset __dll_datatable  ; and the other table too
  mov esi,__dtable
  mov ecx,DLL_DATATABLE_SIZE
  copyECX

  callp dll_main,hnd         ; read QDLL.TXT for the purpose of dll_main

  cmp eax,ERROR
  je bad

; everything's fine and dandy
  popad
  xor eax,eax
  ret
bad:
; some kinda error happened. Bad.
  popad
  mov eax,ERROR
  ret
dll_init endp

_endseg

end dll_init
