include src\qlib.inc
include src\math.inc
include math.inc
include string.inc

_ftoa_ equ _ftoa1_

.code

chk_nan_inf proc private
  ;check for NAN and INF in st
  fxam
  fstsw ax
  ffree st
  _fwait
  and ah,1000111b                       ;mask C? flags
  
  .if ah == 001b
    callp strcpy,edi,"+NAN"
    mov eax,1
    ret
  .endif
  .if ah == 011b
    callp strcpy,edi,"-NAN"
    mov eax,1
    ret
  .endif
  .if ah == 101b
    callp strcpy,edi,"+INF"
    mov eax,1
    ret
  .endif
  .if ah == 111b
    callp strcpy,edi,"-INF"
    mov eax,1
    ret
  .endif
  xor eax,eax
  ret
chk_nan_inf endp

include etoa.asm

.data

MAX_FTOA real8 +1.0e8
MIN_FTOA real8 -1.0e8

.code

ftoa proc, a:REAL8, string:dword, decimals:dword
  fld a
  fcomp MAX_FTOA
  fstsw ax
  _fwait
  sahf
  jbe @f
  jmp _etoa
@@:
  fld a
  fcomp MIN_FTOA
  fstsw ax
  _fwait
  sahf
  jae @f
  jmp _etoa
@@:
_ftoa:
  callp _ftoa_,a,string,decimals,1
  ret
_etoa:  ;use %e instead since the # is too large to print
  callp etoa,a,string,decimals
  ret
ftoa endp

_ftoa1_ proc private, a:REAL8, string:dword, decimals:dword , usefround:byte

  local _sign:byte
  local __t_r1:real8,__t_w1:word,__t_d1:dword
  local __t_rint:dword
  local __r_1:real8
  local __r_int:real8,__r_rnd:real8,__r_rnd2:real8,__r_pow:real8
  local __t_rndd1:dword,__t_rndd2:dword

    pushad

  .if usefround
    frnd a,decimals                       ;round .499999999 to .5 if needed
    fround a,decimals                     ;Round .045 to .050 if needed
  .endif

    fld a
    mov edi,string
    call chk_nan_inf
    .if eax
      popad
      mov eax,string
      ret
    .endif

    fldcw __rnd_0   ;setup RC

    mov     [_sign], 0              ;clear sign marker

    _fint    a                       ;`integrerize' number
    mov     edi, [string]           ;load EDI with string    

    cmp     eax, 0                  ;below zero?
    jge     @@FTOAabovezero         ;NO=>goto FTOAabovezero
    mov     [_sign], 1              ;negative number
    neg     eax                     ;clear sign bit
    xor bptr[a+7],80h               ;remove sign
    mov     [edi], bptr '-'         ;put minus on start of edi

@@FTOAabovezero:
    mov     edx, decimals
    frnd    a , edx                 ;round .499999999 to .5

    _fint    a                       ;integrerize rounded positive number
    call    nibblecount             ;get # of digits
    inc     ecx                     ;increase (nibblecount returns #-1)

    add     edi, ecx                ;add digit count to EDI
    movzx   ebx, _sign
    add     edi, ebx                ;if negative one more char is needed
    push    ecx                     ;save for further use
    push    edi                     ;save for further use

    mov     bptr [edi], '.'         ;put the point
    dec     edi                     ;decrease

    mov     ebx, 10                 ;divider
@@FTOAloop1:
    xor     edx, edx                ;divide eax by 10 until
    div     ebx                     ;ecx decreases from max    
    add     edx, '0'                ;number of digits to 0.
    mov     [edi], bptr dl          ;save number MOD 10+30h
    dec     edi                     ;so it's ASCII code
    dec     ecx                     ;decrease count
    jnz     @@FTOAloop1

    pop     edi                     ;restore string pos at point
    pop     ecx                     ;restore digit count
    inc     edi                     ;goto after point

    ;*********************** [FRACTIONAL] ***********************

    mov     ecx, decimals           ;make ECX a count of decimals desired
    test ecx,ecx
    jnz @f
      mov al,'0'
      stosb
      jmp nodec
@@:
    _fint    a                       ;`integrerize' float number
    mov     [__t_d1], eax           ;move int number to temp location
    fld     a                       ;load float number
    fisub   dptr [__t_d1]           ;subtract whole part so only frac is left
    
    mov     __t_d1, 10
    mov     ebx, 10          

@@FTOAloop2:
    fimul   dptr [__t_d1]           ;multiplicate by 10
    fst     qptr [__t_r1]           ;save mul'ed result
    fwait
    _fint    __t_r1                  ;`integrerize' it

    xor     edx, edx                ;clear edx
    div     ebx                     ;divide by 10 and get remainder

    add     dl, '0'                 ;add 30h to value
    mov     [edi], dl               ;save on string

    inc     edi                     ;increase string index
    dec     ecx                     ;decrease 'precision' counter
    jnz     @@FTOAloop2             

nodec:
    ffree   st(0)                   ;kill st(0)

    mov     bptr [edi], 0           ;put '\0' at end of string
    xor     eax, eax

    fldcw __cw_def   ;setup RC to default
    fwait
    popad
    mov eax,string
    ret
_ftoa1_ endp

comment ~
_ftoa2_ proc private, a:REAL8, string:dword, decimals:dword , usefround:byte
  
  local __r_1:real8,__t_w1:word,__t_d1:dword
  local __r_int:real8,__r_rnd:real8,__r_rnd2:real8,__r_pow:real8
  local __t_rndd1:dword,__t_rndd2:dword

  pushad

  .if usefround
    frnd a,decimals                       ;round .499999999 to .5 if needed
    fround a,decimals                     ;Round .045 to .050 if needed
  .endif

  fld a
  mov edi,string                        ;load EDI with string
  call chk_nan_inf                      ;frees st(0)
  .if eax
    popad
    mov eax,string
    ret
  .endif

  fld a
  ftst
  ffree st
  fstsw ax
  sahf

  jae @f                                ;positive # or zero
 
  xor bptr[a+7],80h                     ;remove sign
  mov al,'-'
  stosb                                 ;put minus on start of edi

@@:
  callp log10,a                         ;get exponent part
  ftst  ;fcom 0.0
  jae @f
  ffree st(0)                           ;negative exponent
  fld a
  mov al,'0'
  stosb
  jmp cont
@@:
  fldcw __rnd_up   ;round up
  frndint
  fldcw __cw_def
  fist __t_d1      ;# of digits before '.'
  mov ecx,__t_d1
  .if ecx==0  ;no digits
    mov al,'0'
    ffree st(0)
    stosb
    jmp cont
  .endif
  fstp __r_1
  callp pow10,__r_1

  fld a
  fxch
  fdivp st(1),st

  ;fmul __ten ;not needed?
start:
  fist __t_d1
  fild __t_d1
  fxch
  fsubp st(1),st
  mov al,bptr __t_d1

  add al,'0'                            ;convert digit to char
  stosb                                 ;save char
  fmul __ten
  dec ecx                               ;decrease count
  jnz start

cont:
  mov al,'.'
  stosb
  mov ecx,decimals

start2:
  fist __t_d1
  fild __t_d1
  fxch
  fsubp st(1),st
  mov al,bptr __t_d1

  add al,'0'                            ;convert digit to char
  stosb                                 ;save char
  fmul __ten
  dec ecx                               ;decrease count
  jnz start2

  xor al,al   ;NULL terminator
  stosb

  popad
  mov eax,string
  ret
_ftoa2_ endp
~

nibblecount proc private
    push eax
    push ebx
    push edx

    xor     ecx, ecx
    mov     ebx, 10

@@NCloop:
    xor     edx, edx
    div     ebx
    cmp     eax, 0
    je      @@NCend
    inc     ecx
    jmp     @@NCloop

@@NCend:
    pop edx
    pop ebx
    pop eax
    ret
nibblecount endp

;This is not an ANSI C pow (this is an integer POW)

_pow PROC private uses ebx ecx edx,a1:dword,a2:dword       ;power(number, power)
  mov ecx, a2
  cmp ecx, 0
  .if carry? || zero?
    mov eax,1
    ret
  .endif

  mov ebx, a1
  mov eax, ebx
  xor edx, edx
  jmp start
@@:
  mul ebx
start:
  dec ecx
  jnz @b
  ret
_pow ENDP

_endseg

end
