;LZW compression algo
; by : Peter Quiring

.data?
  bad_lzw db ?

.code

doutput proc private   ;output string and return 1st byte
  ;output the whole string and return the 1st byte of string
  ;put 1st byte into hash table (so that last byte of string will
  ;  be successfully outputed (it's very confusing)

  ;nc=code obtained from input stream data
  ;code=current code pos in hash table

  local _flg:byte,fb:byte

  mov _flg,0  ;indicates that string used does not have a suffix
  mov ebx,esp  ;save stack pos
  xor eax,eax
  mov ax,nc    ;to be outputed
@@:
  .if ax<100h
    ;push code and done!
    mov fb,al    ;first byte
    dec esp
    mov [esp],al
    jmp done
  .endif
  .if ax==code
    mov ax,oc  ;then it simply is the OC
    .if _flg
      jmp bad
    .endif
    inc _flg  ;this can only happen once (if it happens more the data is corrupt)
    jmp @b
  .endif
;push the suffix
  xor ecx,ecx
  mov cx,ax
  sub cx,FIRST_CODE
  shl ecx,2
  add ecx,offset ht
  mov al,[ecx+2]      ;get suffix
  dec esp
  mov [esp],al
  mov ax,[ecx]    ;get prefix
  jmp @b
done:
  ;undo stack
@@:
  mov al,[esp]
  stosb
  inc esp
  inc dlen
  .if esp!=ebx
    jmp @b
  .endif
  mov al,fb
  .if _flg
    ;output fb again
    stosb
    inc dlen
  .endif
  ret
bad:
  inc bad_lzw
  ret
doutput endp

_lzw_decomp proc private,dest:dword,src:dword
  
  pushad
  mov bo,7
  mov nb,9
  mov esi,src
  mov edi,dest
  mov bad_lzw,0
restart:
  mov nb,9
  mov code,FIRST_CODE
  call read_code
  mov oc,ax
  .if ax==EOF_CODE
    jmp dedone
  .endif
  .if ax>=100h
    jmp bad
  .endif
  stosb
  dec dlen
dc1:  ;repeat until we get code EOF CODE
    .if bad_lzw
      jmp bad
    .endif
    call read_code
    .if ax==EOF_CODE
      jmp dedone
    .endif
    .if ax==CLR_CODE
      jmp restart
    .endif
    mov nc,ax
    call doutput
    mov suffix,al
    xor ebx,ebx
    mov bx,code
    sub ebx,FIRST_CODE
    shl ebx,2
    xor eax,eax
    mov ah,suffix
    shl eax,8
    mov ax,oc
    mov dptr[ebx+ht],eax   ;set prefix:suffix
    inc code
    .if code==512 || code==1024 || code==2048
      inc nb
    .elseif code==4096
      call read_code  ;must be clear code now
      .if ax==CLR_CODE
        jmp restart
      .else
        ;may be last code
        .if ax<100h
          stosb
          call read_code
          .if ax==CLR_CODE
            jmp restart
          .endif
        .endif
      .endif
      jmp bad
    .endif
    mov ax,nc       ;oc=nc;
    mov oc,ax
    jmp dc1
dedone:
  sub edi,dest  ;EDI = total undecompressed
  mov [esp+4*7],edi  ;save EAX on return
  popad
  ret
bad:
  popad
  mov eax,ERROR
  ret
_lzw_decomp endp

