include src\qlib.inc
include src\math.inc
include math.inc
include errno.inc
include string.inc

.code

pow PROC, val:REAL8, power:REAL8

    local __t_r1:real8

    mov errno,0

    fld val
    fcomp __ZERO  
    fstsw ax
    _fwait
    sahf
    .if zero?
      fld power
      fcomp __ZERO
      fstsw ax
      _fwait
      sahf
      .if zero?      ;this is ANSI C specs
        fld1   ;load one!
        _fwait
        ret
      .endif
      fldz     ;0**power = 0 always
      _fwait
      ret
    .endif
    fld power
    fcomp __ZERO
    fstsw ax
    _fwait
    sahf
    .if zero?      ;this is ANSI C specs
      fld1   ;load one!
      _fwait
      ret
    .endif

    callp   log,val                         ; calculate log of val

    fld power                               ; load power

    fmulp   st(1), st(0)                    ; multiply them
    fstp    __t_r1                          ; save result
    _fwait

    callp   exp,__t_r1                      ; calculate exp func of result
    CHKF                                    ; setup error codes

    CleanREAL8

    _fwait
    ret
pow  ENDP

_endseg

end
