; *******************************************************
; *	File Name Split Routine				*
; *							*
; * Fix by Sune Marcher, 02/22/98:                      *
; *   uses C strings and runs under 32bit pmode         *
; * Fix by Peter Quiring, 03/20/98:                     *
; *   changed layout for QLIB (no code change)          *
; * Fix by Peter Quiring, 03/28/98:                     *
; *   many bugs were fixed, supports long file names    *
; *******************************************************

include src\qlib.inc
include stdlib.inc

.code

fsplit proc full:dword,path:dword,nam:dword,ext:dword
  pushad

  cld
  mov   edi,full
  mov   esi,edi

  ; find end of the string
  or    ecx,-1          ; faster than mov ecx,-1 (2 bytes shorter)
  xor   al,al
  repnz scasb

  not   ecx             ; ..
  dec   ecx             ; string length in ECX

  mov   ebx,ecx

  or    ebx,ebx
  je    @@2

;Get File Extension
  xor ecx,ecx  ;size of extension
  mov edi,ext
@@1:
  cmp   byte ptr [ESI+EBX-1],'.'
  je    gotext
  cmp   byte ptr [ESI+EBX-1],'\'
  je    noext
  cmp   byte ptr [ESI+EBX-1],':'
  je    noext
  inc   ecx
  dec   ebx
  jnz   @@1

noext:
  add ebx,ecx  ;move back for FileName checking
  xor ecx,ecx
  inc ebx  ;We are going to DEC for '.' but there is none

gotext:
  ;Copy ECX bytes [ESI+EBX] => ext
  call CopyString

  dec ebx  ;DEC for '.' (removed)

;Get File Name
  mov edi,nam
  xor ecx,ecx
  test ebx,ebx
  jz noname
@@2:
  cmp   byte ptr [ESI+EBX-1],'\'
  je    @@3
  cmp   byte ptr [ESI+EBX-1],':'
  je    @@3
  inc   ecx
  dec   ebx
  jnz   @@2

@@3:
noname:
  ;Copy ECX bytes [ESI+EBX] => ext
  call CopyString

;Get PATH
  mov edi,path
  xor ecx,ecx
  test ebx,ebx
  jz nopath
  mov ecx,ebx
  xor ebx,ebx

nopath:
  ;Copy ECX bytes [ESI+EBX] => ext
  call CopyString

  popad
  ret
fsplit endp

CopyString proc private
  ; Input : ESI+EBX = pointer to copy from
  ;       : EDI = pointer to copy to
  ;       : ECX = amount to copy

  test edi,edi
  jz @@out

  push esi
  add esi,ebx
  copyECX   ;trashes AL
  xor al,al
  stosb  ;Store NULL terminator
  pop esi

@@out:
  ret
CopyString endp

_endseg

end
