include src\qlib.inc
include src\alloc.inc
include errno.inc
include alloc.inc

.code

__heapchk proc private
  mov errno,0
  xor eax,eax                         ; # of free blocks
  xor ebx,ebx                         ; total # of blocks
  xor dl,dl                           ; free block flag
   ;If I find two adjacent free blocks then I return an Error
   ; and report that the blocks are corrupt.  The memory
   ; management routines should never leave two adjacent free blocks.

; _baseram check should be for 0, not MCB
  mov ecx,_baseram                    ; get offset of heap pool
  test ecx,ecx                        ; no heap pool?
  jnz loop1

  ; _baseram==0 if we get here
  mov eax,_HEAPEMPTY
  mov dl,1  ;Error flag
  ret

corrupt:
  mov errno,ECONTR   ;memory blocks destroyed
  mov eax,_HEAPBADNODE
  mov dl,1
  ret

loop1:
; now, start adding up
  ifdef __MEM_CHK__
    cmp [ecx].heads.magic,MB_SIG
    jne corrupt
  endif

  test [ecx].heads.flgs,MB_FREE        ; check if this block is marked "free"
  jz notfree

  test dl,dl
  jnz corrupt
  inc dl
  inc eax
  inc ebx        ; FIX : v2.11 : Beta #2 : this was setup wrong!
  jmp i_ok1      ;
notfree:
  xor dl,dl
  inc ebx

i_ok1:

  test [ecx].heads.flgs,MB_LAST        ; check if this is the last block
  jnz done                             ; if it is, then we're done

  ; move pointer to next MCB, then loop the loop
  add ecx,[ecx].heads.siz
  add ecx,sizeof heads                ; ECX=next MCB
  jmp loop1

done:
  xor dl,dl  ;no error
  ret
__heapchk endp

_heapchk proc uses ebx ecx edx
  call __heapchk
  test dl,dl
  jnz @f
    mov eax,_HEAPOK
@@:
  ret
_heapchk endp

_heapset proc uses ebx ecx edx edi,fill:byte
; Sets all memory flagged as "free" to 'fill'
; input:  nothing
; output: nothing

  mov al,fill
  mov ah,al
  push ax
  push ax
  pop eax

  mov ebx,_baseram
  test ebx,ebx
  jnz zaf_loop

  mov eax,_HEAPEMPTY
  ret

zaf_done:
  mov eax,_HEAPOK
  ret

corrupt:
  mov errno,ECONTR   ;memory blocks destroyed
  mov eax,_HEAPBADNODE
  ret

zaf_loop:
  test [ebx].heads.flgs,MB_FREE
  jz   zaf_notfree

;  SPEED is needed here! If you have, say 60 megs of free memory
;  to zero, it helps a lot NOT to call a function to zero mem (especially
;  if the memory is in multiple fragments...if it's in one blob, it's
;  not much of a difference, really). You can use the below three lines
;  of code instead of the whole memory store if you want to.

;  mov  ecx,ebx
;  add  ecx,sizeof heads
;  callp setmem,ecx,[ebx].heads.siz,0

  test dl,dl
  jnz corrupt
  inc dl
  mov edi,ebx
  add edi,sizeof heads
  mov ecx,[ebx].heads.siz
  _storeECX dh
  jmp @f

zaf_notfree:
  xor dl,dl

@@:
  test [ebx].heads.flgs,MB_LAST
  jnz zaf_done

  add ebx,[ebx].heads.siz
  add ebx,sizeof heads
  jmp zaf_loop
_heapset endp

_heapfrag proc uses ebx ecx edx
  ;returns Fragmentation percentage
  ; EAX = (# of free blocks) / (total # of blocks) * 100%
  ; Check errno for errors, not the return value.

  call __heapchk

  test dl,dl
  jnz bad

  imul eax,100    ;Got no decimal so I gotta *100 first
  xor edx,edx
  div ebx
  ret

bad:
  xor eax,eax     ;Error
  ret
_heapfrag endp

_heapwalk proc uses ebx ecx edx,_hi:dword
  mov ebx,_hi
  cmp [ebx]._heapinfo._pentry,0
  jnz walk
  mov ecx,_baseram
  test ecx,ecx
  jnz @f
  mov eax,_HEAPEMPTY
  ret
corrupt:
  mov errno,ECONTR
  mov eax,_HEAPBADNODE
  ret
@@:
  ifdef __MEM_CHK__
    cmp [ecx].heads.magic,MB_SIG
    jne corrupt
  endif
  mov [ebx]._heapinfo._pentry,ecx
  mov eax,[ecx].heads.siz
  mov [ebx]._heapinfo._size,eax
  mov al,[ecx].heads.flgs
  and al,MB_FREE  ;same as _FREEENTRY
  mov [ebx]._heapinfo._useflag,al
  mov eax,_HEAPOK
  ret
walk:
  mov ecx,[ebx]._heapinfo._pentry
  ifdef __MEM_CHK__
    cmp [ecx].heads.magic,MB_SIG
    jne corrupt
  endif
  test [ecx].heads.flgs,MB_LAST
  jnz @f
  add ecx,[ecx].heads.siz
  add ecx,sizeof heads
  jmp @b
@@:
  mov eax,_HEAPEND
  ret
_heapwalk endp

_memisblock proc block:dword
  mov  eax,block
  sub  eax,sizeof heads
  cmp  [eax].heads.magic,MB_SIG
  jne  @not
  xor eax,eax
  ret
@not:
  mov eax,ERROR
  ret
_memisblock endp

_memblksize proc block:dword
  mov eax,block
  sub eax,sizeof heads
  cmp [eax].heads.magic,MB_SIG
  jne @not
  mov eax,[eax].heads.siz
  ret
@not:
  mov eax,ERROR
  ret
_memblksize endp

_endseg

end
