include src\alloc.inc

; see alloc.asm for details

.code

mem_init proc private
  local siz:dword
  sub esp,48
  mov ax,0500h
  mov edi,esp
  int 31h
  jc outofram
  mov eax,[esp]  ;RAM avail
  add esp,48                               ;FIX : v2.00 Beta #2 : this was
  .if eax>HEAP_MAX   ;too much?            ;before the mov eax,[edi]
    mov eax,HEAP_MAX
  .endif

  ;round to highest 4K
  add eax,0fffh
  and eax,0fffff000h

  mov siz,eax
  test eax,eax
  jnz @f
    ;no XMS wanted
    ret
@@:
; under Windoze and DOS/4GW sometimes more RAM was said to be avail
; than there really is.  So I slowly decrease the amount requested until
; it works or until it drops below HEAP_MIN

retry:
  .if eax<HEAP_MIN
    jmp outofram
  .endif
  mov ebx,eax
  shr ebx,16
  mov cx,ax
  mov ax,0501h
  int 31h
  .if carry?
    .if siz<64*1024+1
      jmp outofram
    .endif
    sub siz,64*1024
    mov eax,siz
    jmp retry
  .endif
  shl ebx,16
  mov bx,cx
  mov _baseram,ebx
  shl esi,16
  mov si,di
  mov _handle,esi

  mov [ebx].heads.magic,MB_SIG
  mov [ebx].heads.flgs,MB_LAST or MB_FREE
  mov [ebx].heads.prev,0        ;no prev!
  mov eax,siz  ;FIX : v2.00 Beta #2 : This was not here !?!
  sub eax,sizeof heads
  mov [ebx].heads.siz,eax
  ret
mem_init endp

public _qlib_error_ram

outofram:
_qlib_error_ram:
  callp printf,"Error:Out of memory...\n"
  mov eax,HEAP_MIN
  add eax,1023
  shr eax,10  ;divide by 1k
  callp printf,"Require at least %d K of memory.\n",eax
  mov ax,4c03h
  int 21h

